/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.client.devui;

import com.storyanvil.cogwheel.client.devui.DWCodeEditor;
import com.storyanvil.cogwheel.util.Bi;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public class DevHighlighters {

    public static class JSON
    extends DWCodeEditor.Highlighter {
        @Override
        public MutableComponent highlight(int lineNumber, ArrayList<Bi<String, MutableComponent>> code, String line) {
            ColorHelper helper = new ColorHelper(line);
            int prv = 32;
            for (int i = 0; i < line.length(); ++i) {
                char c = line.charAt(i);
                if (c == '\"' && prv != 92) {
                    char c2;
                    int ii;
                    int prv2 = 32;
                    for (ii = i + 1; ii < line.length() && ((c2 = line.charAt(ii)) != '\"' || prv2 == 92); ++ii) {
                        prv2 = c2;
                    }
                    helper.color(i, ++ii, CodeColor.STRING);
                    i = ii;
                    prv = c;
                    continue;
                }
                if (Character.isDigit(c)) {
                    helper.colorSingle(i, CodeColor.NUMBER);
                } else if (c == 'l' && line.substring(i - 4, i + 1).equals(" null")) {
                    helper.color(i - 4, i + 1, CodeColor.KEYWORD);
                }
                prv = c;
            }
            return helper.compile();
        }
    }

    public static class CogScript
    extends DWCodeEditor.Highlighter {
        @Override
        public MutableComponent highlight(int lineNumber, ArrayList<Bi<String, MutableComponent>> code, String line) {
            ColorHelper helper = new ColorHelper(line);
            CogScript.process(helper, 0, line.length(), line);
            return helper.compile();
        }

        public static void process(ColorHelper helper, int from, int to, String fullLine) {
            String sub = fullLine.substring(from, to);
        }
    }

    public static class StoryAnvilDialog
    extends DWCodeEditor.Highlighter {
        @Override
        public MutableComponent highlight(int lineNumber, ArrayList<Bi<String, MutableComponent>> code, String line) {
            int offset;
            ColorHelper helper = new ColorHelper(line);
            if (line.isBlank()) {
                return helper.compile();
            }
            for (offset = 0; offset < line.length() - 1 && line.charAt(offset) == ' '; ++offset) {
            }
            char c = line.charAt(offset);
            if (c == '!') {
                CogScript.process(helper, offset + 1, line.length(), line);
            } else if (c == '#') {
                helper.color(offset, line.length(), CodeColor.COMMENT);
            } else if (c == '@') {
                char sepC;
                int sep = offset;
                int bound = line.length() - 1;
                while (sep < bound && (sepC = line.charAt(++sep)) != ':' && sepC != '?' && sepC != '!') {
                }
                helper.color(offset, sep, CodeColor.VARIABLE);
                helper.color(sep, sep + 1, CodeColor.KEYWORD);
            } else if (c == '+') {
                helper.color(offset, offset + 1, CodeColor.SPECIAL);
            } else if (c != '/') {
                helper.color(offset, line.length(), CodeColor.ERROR);
            }
            return helper.compile();
        }
    }

    public static class Empty
    extends DWCodeEditor.Highlighter {
        @Override
        public MutableComponent highlight(int lineNumber, ArrayList<Bi<String, MutableComponent>> code, String line) {
            return Component.m_237113_((String)line);
        }
    }

    public static interface ColorSup
    extends Supplier<Integer>,
    UnaryOperator<Style> {
        @Override
        default public Style apply(Style style) {
            return style;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum CodeColor implements ColorSup
    {
        WHITE(ChatFormatting.WHITE.m_126665_()),
        STRING(ChatFormatting.DARK_GREEN.m_126665_()),
        COMMENT(ChatFormatting.DARK_GRAY.m_126665_()),
        ERROR(ChatFormatting.RED.m_126665_()){

            @Override
            public Style apply(Style style) {
                return style.m_178522_(Boolean.valueOf(true));
            }
        }
        ,
        VARIABLE(ChatFormatting.BLUE.m_126665_()){

            @Override
            public Style apply(Style style) {
                return style.m_131162_(Boolean.valueOf(true));
            }
        }
        ,
        KEYWORD(ChatFormatting.GOLD.m_126665_()),
        SPECIAL(ChatFormatting.AQUA.m_126665_()),
        NUMBER(ChatFormatting.DARK_AQUA.m_126665_());

        public final int color;

        private CodeColor(int color) {
            this.color = color;
        }

        @Override
        public Integer get() {
            return this.color;
        }
    }

    public static class ColorHelper {
        private String line;
        private ColorSup[] colors;

        public ColorHelper(String line) {
            this.line = line;
            this.colors = new ColorSup[line.length()];
            Arrays.fill(this.colors, CodeColor.WHITE);
        }

        public void color(int from, int to, ColorSup color) {
            for (int i = from; i < to && i < this.colors.length; ++i) {
                this.colors[i] = color;
            }
        }

        public void colorSingle(int i, ColorSup colorSup) {
            this.colors[i] = colorSup;
        }

        public MutableComponent compile() {
            MutableComponent cp = Component.m_237119_().m_130940_(ChatFormatting.RESET);
            Integer color = null;
            ColorSup sup = null;
            int from = 0;
            for (int i = 0; i < this.colors.length; ++i) {
                int c = (Integer)this.colors[i].get();
                if (color == null) {
                    color = c;
                    sup = this.colors[i];
                    from = i;
                    continue;
                }
                if (color == c) continue;
                MutableComponent n = Component.m_237113_((String)this.line.substring(from, i));
                Integer finalColor = color;
                ColorSup finalSup = sup;
                n.m_130938_(s -> finalSup.apply((Style)s).m_178520_(finalColor.intValue()));
                cp.m_7220_((Component)Component.m_237119_().m_130940_(ChatFormatting.RESET)).m_7220_((Component)n);
                color = c;
                from = i;
                sup = this.colors[i];
            }
            MutableComponent n = Component.m_237113_((String)this.line.substring(from));
            if (sup != null) {
                Integer finalColor = color;
                ColorSup finalSup1 = sup;
                n.m_130938_(s -> finalSup1.apply((Style)s).m_178520_(finalColor.intValue()));
            }
            cp.m_7220_((Component)Component.m_237119_().m_130940_(ChatFormatting.RESET)).m_7220_((Component)n);
            return cp;
        }
    }
}

