/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import com.storyanvil.cogwheel.api.Api;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import net.minecraft.client.Minecraft;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CogwheelClientConfig {
    private static final Logger log = LoggerFactory.getLogger((String)"STORYANVIL/COGWHEEL/CLIENT");
    private static JsonObject json = null;
    private static boolean disableDevUI = false;
    private static boolean disableQuestUI = false;

    private static boolean getBool(String name, boolean defauld) {
        JsonElement e = json.get(name);
        if (e == null || !e.isJsonPrimitive()) {
            json.addProperty(name, Boolean.valueOf(defauld));
            return defauld;
        }
        try {
            return e.getAsBoolean();
        }
        catch (IllegalStateException | UnsupportedOperationException ignored) {
            json.addProperty(name, Boolean.valueOf(defauld));
            return defauld;
        }
    }

    private static List<String> getStringArray(String name, List<String> defauld) {
        JsonElement e = json.get(name);
        if (e == null || !e.isJsonArray()) {
            JsonArray a = new JsonArray();
            for (String s : defauld) {
                a.add((JsonElement)new JsonPrimitive(s));
            }
            json.add(name, (JsonElement)a);
            return defauld;
        }
        JsonArray array = e.getAsJsonArray();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < array.size(); ++i) {
            arrayList.add(array.get(i).getAsString());
        }
        return arrayList;
    }

    @Api.Stable(since="2.10.2")
    @Api.MixinsNotAllowed(where="CogwheelClientConfig#mixinsEntrypoint")
    public static synchronized void reload() {
        File config = new File(Minecraft.m_91087_().f_91069_, "config/cog/config-client.json");
        try (FileReader fr = new FileReader(config);
             Scanner sc = new Scanner(fr);){
            StringBuilder buffer = new StringBuilder();
            while (sc.hasNextLine()) {
                String line = sc.nextLine();
                buffer.append(line).append('\n');
            }
            json = JsonParser.parseString((String)buffer.toString()).getAsJsonObject();
        }
        catch (FileNotFoundException e) {
            log.error("[CFG] Failed to load config-client! Config files does not exist");
            try {
                if (!config.createNewFile()) {
                    throw new IOException("Failed to create config-client for unknown reasons");
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        catch (IOException e) {
            log.error("[CFG] Failed to load config-client! Default values will be used!", (Throwable)e);
        }
        catch (JsonParseException | IllegalStateException e) {
            log.error("[CFG] Failed to load config-client! Invalid format! Default values will be used!", e);
        }
        if (json == null) {
            json = new JsonObject();
        }
        json.addProperty("wiki", "https://storyanvil.github.io/wiki/wiki.html?p=wiki/projects/cogwheel/clientConfig");
        disableDevUI = CogwheelClientConfig.getBool("disableDevUI", false);
        disableQuestUI = CogwheelClientConfig.getBool("disableQuestUI", false);
        CogwheelClientConfig.mixinsEntrypoint(json);
        try (FileWriter fw = new FileWriter(config);){
            try {
                StringWriter stringWriter = new StringWriter();
                JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
                jsonWriter.setLenient(true);
                jsonWriter.setIndent("    ");
                Streams.write((JsonElement)json, (JsonWriter)jsonWriter);
                fw.write(stringWriter.toString());
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            fw.flush();
        }
        catch (IOException e) {
            log.error("[CFG] Failed to updated config-client!", (Throwable)e);
        }
        json = null;
        log.info("[CFG] Config reloaded!");
    }

    public static boolean isDisableDevUI() {
        return disableDevUI;
    }

    public static boolean isDisableQuestUI() {
        return disableQuestUI;
    }

    @Api.Stable(since="2.10.2")
    @Api.MixinIntoHere
    public static void mixinsEntrypoint(JsonObject config) {
    }
}

