/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;

public class SyncArray<T>
extends ArrayList<T> {
    private boolean frozen = false;

    public void freeze() {
        this.frozen = true;
    }

    @Override
    public synchronized T remove(int index) {
        if (this.frozen) {
            throw new IllegalStateException("Array is frozen!");
        }
        return (T)super.remove(index);
    }

    @Override
    public synchronized void add(int index, T element) {
        if (this.frozen) {
            throw new IllegalStateException("Array is frozen!");
        }
        super.add(index, element);
    }

    @Override
    public synchronized boolean add(T t) {
        if (this.frozen) {
            throw new IllegalStateException("Array is frozen!");
        }
        return super.add(t);
    }

    @Override
    public synchronized T set(int index, T element) {
        if (this.frozen) {
            throw new IllegalStateException("Array is frozen!");
        }
        return super.set(index, element);
    }

    @Override
    public synchronized T get(int index) {
        return (T)super.get(index);
    }

    @Override
    public synchronized void sort(Comparator<? super T> c) {
        if (this.frozen) {
            throw new IllegalStateException("Array is frozen!");
        }
        super.sort(c);
    }

    @Override
    public synchronized void replaceAll(UnaryOperator<T> operator) {
        if (this.frozen) {
            throw new IllegalStateException("Array is frozen!");
        }
        super.replaceAll(operator);
    }

    @Override
    public synchronized boolean removeIf(Predicate<? super T> filter) {
        if (this.frozen) {
            throw new IllegalStateException("Array is frozen!");
        }
        return super.removeIf(filter);
    }

    @Override
    public synchronized void forEach(Consumer<? super T> action) {
        super.forEach(action);
    }

    @Override
    @NotNull
    public synchronized List<T> subList(int fromIndex, int toIndex) {
        return super.subList(fromIndex, toIndex);
    }

    @Override
    protected synchronized void removeRange(int fromIndex, int toIndex) {
        if (this.frozen) {
            throw new IllegalStateException("Array is frozen!");
        }
        super.removeRange(fromIndex, toIndex);
    }

    @Override
    public synchronized boolean removeAll(Collection<?> c) {
        if (this.frozen) {
            throw new IllegalStateException("Array is frozen!");
        }
        return super.removeAll(c);
    }

    @Override
    public synchronized boolean retainAll(Collection<?> c) {
        if (this.frozen) {
            throw new IllegalStateException("Array is frozen!");
        }
        return super.retainAll(c);
    }

    @Override
    public synchronized boolean remove(Object o) {
        if (this.frozen) {
            throw new IllegalStateException("Array is frozen!");
        }
        return super.remove(o);
    }

    @Override
    public synchronized void clear() {
        if (this.frozen) {
            throw new IllegalStateException("Array is frozen!");
        }
        super.clear();
    }

    public synchronized void dispose() {
        super.clear();
    }

    @Override
    public synchronized Object @NotNull [] toArray() {
        return super.toArray();
    }

    @Override
    public synchronized <T1> T1 @NotNull [] toArray(T1[] a) {
        return super.toArray(a);
    }

    @Override
    public synchronized boolean contains(Object o) {
        return super.contains(o);
    }

    @Override
    public synchronized int indexOf(Object o) {
        return super.indexOf(o);
    }

    @Override
    public synchronized int lastIndexOf(Object o) {
        return super.lastIndexOf(o);
    }
}

