/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.infrastructure;

import com.google.gson.JsonObject;
import com.storyanvil.cogwheel.CogwheelExecutor;
import com.storyanvil.cogwheel.EventBus;
import com.storyanvil.cogwheel.infrastructure.ArgumentData;
import com.storyanvil.cogwheel.infrastructure.CogPropertyManager;
import com.storyanvil.cogwheel.infrastructure.cog.CogString;
import com.storyanvil.cogwheel.infrastructure.cog.PreventSubCalling;
import com.storyanvil.cogwheel.infrastructure.cog.SubCallPostPrevention;
import com.storyanvil.cogwheel.infrastructure.script.DispatchedScript;
import com.storyanvil.cogwheel.util.EasyPropManager;
import com.storyanvil.cogwheel.util.JsonLike;
import com.storyanvil.cogwheel.util.ObjectMonitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StoryAction<T>
implements ObjectMonitor.IMonitored,
CogPropertyManager,
JsonLike {
    private static final ObjectMonitor<StoryAction<?>> MONITOR = new ObjectMonitor();
    private String actionLabel = null;
    private Runnable onExit;
    private boolean done = false;
    private static final EasyPropManager MANAGER = new EasyPropManager("storyAction", StoryAction::registerProps);

    public abstract void proceed(T var1);

    public abstract boolean freeToGo(T var1);

    public String toString() {
        return this.getClass().getName() + "$ACT#";
    }

    public String getActionLabel() {
        return this.actionLabel;
    }

    public void setActionLabel(String actionLabel) {
        this.actionLabel = actionLabel;
    }

    public void hitLabel() {
        if (this.actionLabel != null) {
            EventBus.hitLabel(this.actionLabel, this);
        }
        if (this.onExit != null) {
            this.onExit.run();
        }
        this.done = true;
    }

    public boolean isDone() {
        return this.done;
    }

    public StoryAction() {
        MONITOR.register(this);
    }

    @Override
    public void reportState(@NotNull StringBuilder sb) {
        sb.append(this);
    }

    public void setOnExit(Runnable onExit) {
        if (this.onExit != null) {
            throw new RuntimeException("OnExit already set!");
        }
        this.onExit = onExit;
    }

    private static void registerProps(@NotNull EasyPropManager manager) {
        manager.reg("setLabel", (name, args, script, o) -> {
            StoryAction action = (StoryAction)o;
            action.setActionLabel(args.getString(0));
            return action;
        });
        manager.reg("getLabel", (name, args, script, o) -> {
            StoryAction action = (StoryAction)o;
            return new CogString(action.getActionLabel());
        });
        manager.reg("blocking", (name, args, script, o) -> {
            final StoryAction action = (StoryAction)o;
            throw new PreventSubCalling(new SubCallPostPrevention(){

                @Override
                public void prevent(String variable) {
                    if (action.isDone()) {
                        CogwheelExecutor.schedule(script::lineDispatcher);
                        return;
                    }
                    action.setOnExit(() -> CogwheelExecutor.schedule(script::lineDispatcher));
                }
            });
        });
        manager.reg("then", (name, args, script, o) -> {
            StoryAction action = (StoryAction)o;
            action.setOnExit(() -> args.requireInvoker(0).unsafeRunnable(args, script).run());
            return action;
        });
    }

    @Override
    public boolean hasOwnProperty(String name) {
        return MANAGER.hasOwnProperty(name);
    }

    @Override
    @Nullable
    public CogPropertyManager getProperty(String name, ArgumentData args, DispatchedScript script) {
        return MANAGER.get(name).handle(name, args, script, this);
    }

    @Override
    public boolean equalsTo(CogPropertyManager o) {
        return o == this;
    }

    @Override
    public final JsonObject toJSON() {
        JsonObject obj = new JsonObject();
        obj.addProperty("type", this.getClass().getCanonicalName());
        return obj;
    }

    protected void toJSON(JsonObject obj) {
    }

    public static abstract class Ticking<T>
    extends StoryAction<T> {
        private int ticksLeft;

        public Ticking(int ticksLeft) {
            this.ticksLeft = ticksLeft;
        }

        @Override
        public boolean freeToGo(T myself) {
            if (this.ticksLeft > 0) {
                --this.ticksLeft;
                return false;
            }
            this.onEnding();
            this.hitLabel();
            return true;
        }

        public void onEnding() {
        }

        @Override
        protected void toJSON(JsonObject obj) {
            super.toJSON(obj);
            obj.addProperty("ticksLeft", (Number)this.ticksLeft);
        }
    }

    public static abstract class Instant<T>
    extends StoryAction<T> {
        @Override
        public boolean freeToGo(T myself) {
            this.hitLabel();
            return true;
        }
    }
}

