/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.infrastructure.cog;

import com.storyanvil.cogwheel.infrastructure.ArgumentData;
import com.storyanvil.cogwheel.infrastructure.CogPropertyManager;
import com.storyanvil.cogwheel.infrastructure.cog.PreventSubCalling;
import com.storyanvil.cogwheel.infrastructure.cog.PropertyHandler;
import com.storyanvil.cogwheel.infrastructure.env.CogScriptEnvironment;
import com.storyanvil.cogwheel.infrastructure.module.CMA;
import com.storyanvil.cogwheel.infrastructure.script.DispatchedScript;
import com.storyanvil.cogwheel.util.EasyPropManager;
import com.storyanvil.cogwheel.util.ScriptStorage;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class CogInvoker
implements CogPropertyManager {
    private static final EasyPropManager MANAGER = new EasyPropManager("callable", CogInvoker::registerProps);
    private PropertyHandler invoker;

    private CogInvoker(PropertyHandler invoker) {
        this.invoker = invoker;
    }

    private static void registerProps(EasyPropManager manager) {
        manager.reg("invoke", (name, args, script, o) -> {
            CogInvoker cogCallable = (CogInvoker)o;
            if (cogCallable.invoker == null) {
                return null;
            }
            return cogCallable.invoker.handle(null, args, script, null);
        });
        manager.reg("unlink", (name, args, script, o) -> {
            CogInvoker cogCallable = (CogInvoker)o;
            cogCallable.invoker = null;
            return null;
        });
    }

    @Override
    public boolean hasOwnProperty(String name) {
        return MANAGER.hasOwnProperty(name);
    }

    @Override
    @Nullable
    public CogPropertyManager getProperty(String name, ArgumentData args, DispatchedScript script) throws PreventSubCalling {
        return MANAGER.get(name, args, script, this);
    }

    @Override
    public boolean equalsTo(CogPropertyManager o) {
        return this == o;
    }

    public Runnable unsafeRunnable(ArgumentData args, DispatchedScript script) {
        return () -> this.invoker.handle("invoke", args, script, this);
    }

    public static CogInvoker scriptInvoker(ResourceLocation scriptName) {
        return new CogInvoker((name, args, script, o) -> {
            CogScriptEnvironment.dispatchScriptGlobal(scriptName);
            return null;
        });
    }

    public static CogInvoker eventScriptInvoker(ResourceLocation scriptName) {
        return new CogInvoker((name, args, script, o) -> {
            CogScriptEnvironment.dispatchScriptGlobal(scriptName, (ScriptStorage)((Object)args.get(0)));
            return null;
        });
    }

    public static CogInvoker cmaInvoker(CMA cma, String propertyName) {
        return new CogInvoker((name, args, script, o) -> cma.call(propertyName, args, script));
    }

    public static CogInvoker genericInvoker(CogPropertyManager manager, String propertyName) {
        return new CogInvoker((name, args, script, o) -> manager.getProperty(propertyName, args, script));
    }

    public static CogInvoker javaInvoker(PropertyHandler handler) {
        return new CogInvoker(handler);
    }
}

