/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.infrastructure.cog.early;

import com.storyanvil.cogwheel.CogwheelEngine;
import com.storyanvil.cogwheel.data.SyncArray;
import com.storyanvil.cogwheel.infrastructure.ArgumentData;
import com.storyanvil.cogwheel.infrastructure.CogPropertyManager;
import com.storyanvil.cogwheel.infrastructure.cog.PreventSubCalling;
import com.storyanvil.cogwheel.infrastructure.cog.early.CogEarlyBlock;
import com.storyanvil.cogwheel.infrastructure.cog.early.CogEarlyItem;
import com.storyanvil.cogwheel.infrastructure.script.DispatchedScript;
import com.storyanvil.cogwheel.util.EasyPropManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.Nullable;

public class CogEarlyRegistry
implements CogPropertyManager {
    private static final EasyPropManager MANAGER = new EasyPropManager("earlyreg", manager -> manager.reg("item", (name, args, script, o) -> {
        CogEarlyRegistry registry = (CogEarlyRegistry)o;
        CogEarlyItem item = new CogEarlyItem(args.getString(0));
        registry.items.add(item);
        return item;
    }), CogwheelEngine.EARLY_MANAGER);
    private final String namespace;
    private final DeferredRegister<Item> ITEMS;
    private final DeferredRegister<Block> BLOCKS;
    private final SyncArray<CogEarlyItem> items;
    private final SyncArray<CogEarlyBlock> blocks;

    public CogEarlyRegistry(String namespace) {
        this.namespace = namespace;
        this.ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)namespace);
        this.BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)namespace);
        CogwheelEngine.EARLY.info("Created registry with namespace {}", (Object)namespace);
        this.items = new SyncArray();
        this.blocks = new SyncArray();
    }

    @Override
    public boolean hasOwnProperty(String name) {
        return MANAGER.hasOwnProperty(name);
    }

    @Override
    @Nullable
    public CogPropertyManager getProperty(String name, ArgumentData args, DispatchedScript script) throws PreventSubCalling {
        return MANAGER.get(name).handle(name, args, script, this);
    }

    @Override
    public boolean equalsTo(CogPropertyManager o) {
        return o instanceof CogEarlyRegistry;
    }

    public void register(IEventBus modEventBus) {
        this.items.freeze();
        this.blocks.freeze();
        for (CogEarlyItem cogEarlyItem : this.items) {
            cogEarlyItem.register(this.ITEMS);
        }
        for (CogEarlyBlock cogEarlyBlock : this.blocks) {
            cogEarlyBlock.register(this.BLOCKS);
        }
        this.ITEMS.register(modEventBus);
        this.BLOCKS.register(modEventBus);
        CogwheelEngine.EARLY.info("Finished registry with namespace {}", (Object)this.namespace);
    }
}

