/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.infrastructure.module;

import com.storyanvil.cogwheel.infrastructure.ArgumentData;
import com.storyanvil.cogwheel.infrastructure.CogPropertyManager;
import com.storyanvil.cogwheel.infrastructure.cog.CogInvoker;
import com.storyanvil.cogwheel.infrastructure.cog.PreventSubCalling;
import com.storyanvil.cogwheel.infrastructure.env.CogScriptEnvironment;
import com.storyanvil.cogwheel.infrastructure.module.CMA;
import com.storyanvil.cogwheel.infrastructure.module.ModuleProperty;
import com.storyanvil.cogwheel.infrastructure.script.DispatchedScript;
import com.storyanvil.cogwheel.util.CogExpressionFailure;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CogModule
implements CogPropertyManager {
    private final HashMap<String, ModuleProperty> properties = new HashMap();
    private final CogScriptEnvironment environment;
    private final String name;
    public static final Logger dataFix = LoggerFactory.getLogger((String)"STORYANVIL/COGWHEEL/DATAFIXER");

    /*
     * Enabled aggressive exception aggregation
     */
    public static CogModule build(CogScriptEnvironment env, String script) {
        File scriptFile = new File(Minecraft.m_91087_().f_91069_, "config/" + env.getScript(script));
        if (!scriptFile.exists()) {
            dataFix.error("Module {} does not exist!", (Object)script);
            throw new CogExpressionFailure("Module File does not exist!");
        }
        try (FileReader fr = new FileReader(scriptFile);){
            Scanner sc = new Scanner(fr);
            try {
                CogModule module = new CogModule(env, script.substring(0, script.length() - 4));
                ArrayList<String> property = null;
                String propertyName = null;
                String[] propertyArgs = null;
                int level = 0;
                while (sc.hasNextLine()) {
                    String line = sc.nextLine().trim();
                    if (property == null) {
                        if (!line.startsWith("define ")) continue;
                        property = new ArrayList<String>();
                        String header = line.substring(7);
                        int space = header.indexOf(40);
                        if (space == -1) {
                            throw new CogExpressionFailure("Module line \"" + line + "\" is invalid property header!");
                        }
                        propertyName = header.substring(0, space);
                        if (space == 0) {
                            propertyName = "<init>";
                            property.add("$ = this");
                        }
                        if (!header.endsWith(") {")) {
                            throw new CogExpressionFailure("Module line \"" + line + "\" is invalid property header [TAIL BRACKET MISMATCH]!");
                        }
                        String brackets = header.substring(space + 1, header.length() - 3);
                        propertyArgs = brackets.split(",");
                        level = 0;
                        continue;
                    }
                    if (line.equals("}")) {
                        if (--level >= 0) continue;
                        ModuleProperty moduleProperty = new ModuleProperty(property, module, propertyArgs);
                        module.properties.put(propertyName, moduleProperty);
                        property = null;
                        propertyName = null;
                        propertyArgs = null;
                        level = 0;
                        continue;
                    }
                    if (line.endsWith("{")) {
                        ++level;
                        continue;
                    }
                    property.add(line.trim());
                }
                module.dataFixer();
                CogModule cogModule = module;
                sc.close();
                return cogModule;
            }
            catch (Throwable throwable) {
                try {
                    sc.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CogExpressionFailure("Module import failed while file reading", e);
        }
    }

    public CogModule(CogScriptEnvironment environment, String name) {
        this.environment = environment;
        this.name = name;
    }

    public boolean _hasOwnProperty(String name) {
        if (name.startsWith(":")) {
            name = name.substring(1);
        }
        return this.properties.containsKey(name);
    }

    public ResourceLocation getID() {
        return ResourceLocation.fromNamespaceAndPath((String)this.environment.getUniqueIdentifier(), (String)this.name);
    }

    public CogPropertyManager _getProperty(String name, ArgumentData args, DispatchedScript script, CMA instance) {
        if (name.startsWith(":")) {
            return CogInvoker.cmaInvoker(instance, name);
        }
        return this.properties.get(name).handle(name, args, script, instance);
    }

    @Override
    public boolean hasOwnProperty(String name) {
        return name.equals("new") || name.equals("dump");
    }

    @Override
    @Nullable
    public CogPropertyManager getProperty(String name, ArgumentData args, DispatchedScript script) throws PreventSubCalling {
        if (name.equals("dump")) {
            dataFix.info("MODULE DUMP: >{}<", (Object)this.getID());
            dataFix.info("METHODS:");
            for (Map.Entry<String, ModuleProperty> property : this.properties.entrySet()) {
                dataFix.info(" {} = {}", (Object)property.getKey(), (Object)property.getValue());
            }
            return null;
        }
        return this.properties.get("<init>").handle(name, args, script, null);
    }

    @Override
    public boolean equalsTo(CogPropertyManager o) {
        return o == this;
    }

    public CogScriptEnvironment getEnvironment() {
        return this.environment;
    }

    public void dataFixer() {
        for (ModuleProperty property : this.properties.values()) {
            property.dataFixer();
        }
    }

    public String toString() {
        return "CogModule{properties=" + String.valueOf(this.properties) + ", environment=" + String.valueOf(this.environment) + ", name='" + this.name + "'}";
    }
}

