/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.mixin;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import com.storyanvil.cogwheel.network.devui.DevNetwork;
import com.storyanvil.cogwheel.network.devui.DevOpenViewer;
import com.storyanvil.cogwheel.network.devui.inspector.InspectableBlock;
import com.storyanvil.cogwheel.util.StoryUtils;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={BaseEntityBlock.class})
public class BaseEntityBlockMixin
implements InspectableBlock {
    @Override
    public boolean tryToInspect(@NotNull ServerLevel level, @NotNull ServerPlayer player, @NotNull BlockState state, @NotNull UseOnContext ctx) {
        BlockEntity entity = level.m_7702_(ctx.m_8083_());
        if (entity == null) {
            return false;
        }
        JsonObject nbt = StoryUtils.toCompoundJSON(entity.serializeNBT());
        nbt.addProperty("__cogwheel_engine_class", this.getClass().getCanonicalName());
        try {
            StringWriter stringWriter = new StringWriter();
            JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
            jsonWriter.setLenient(true);
            jsonWriter.setIndent("    ");
            jsonWriter.setSerializeNulls(true);
            Streams.write((JsonElement)nbt, (JsonWriter)jsonWriter);
            DevNetwork.sendFromServer(player, new DevOpenViewer("block.json", stringWriter.toString()));
            return true;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }
}

