/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.network.belt;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.storyanvil.cogwheel.CogwheelExecutor;
import com.storyanvil.cogwheel.EventBus;
import com.storyanvil.cogwheel.config.CogwheelConfig;
import com.storyanvil.cogwheel.network.belt.BeltPacket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Base64;
import java.util.concurrent.CompletableFuture;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeltCommunications {
    public static final Logger log = LoggerFactory.getLogger((String)"STORYANVIL/COGWHEEL/BELT");
    private String host;
    private final HttpClient client;
    private String remoteServerName;
    private String token = null;
    private final ArrayList<BeltPacket> packets = new ArrayList();
    public static final Object SYNC = new Object();

    public static BeltCommunications create(String host) {
        if (CogwheelConfig.isDisablingBelt()) {
            throw new RuntimeException("Belt Protocol is disabled!");
        }
        try {
            URI url = new URI(host);
            BeltCommunications com = new BeltCommunications();
            if (!url.getScheme().equals("belt") && !url.getScheme().equals("sbelt")) {
                throw new RuntimeException("Failed to connect to Belt Protocol host: Invalid protocol scheme");
            }
            com.host = (url.getScheme().startsWith("s") ? "https://" : "http://") + url.getAuthority();
            CogwheelExecutor.scheduleBelt(com::connect);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Failed to connect to Belt Protocol host: Invalid host", e);
        }
        return null;
    }

    public BeltCommunications() {
        this.client = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).followRedirects(HttpClient.Redirect.NORMAL).build();
    }

    private CompletableFuture<HttpResponse<String>> httpGet(String path) {
        HttpRequest.Builder request = HttpRequest.newBuilder().uri(URI.create(this.host + path)).GET().header("User-Agent", "Cogwheel-Engine").header("X-StoryAnvil", "Cogwheel-Engine").timeout(Duration.ofSeconds(10L));
        if (this.token != null) {
            request.header("X-StoryAnvil-Secret", this.token);
        }
        return this.client.sendAsync(request.build(), HttpResponse.BodyHandlers.ofString());
    }

    private CompletableFuture<HttpResponse<String>> httpPost(String path, String body) {
        HttpRequest.Builder request = HttpRequest.newBuilder().uri(URI.create(this.host + path)).POST(HttpRequest.BodyPublishers.ofString(body)).header("User-Agent", "Cogwheel-Engine").header("X-StoryAnvil", "Cogwheel-Engine").timeout(Duration.ofSeconds(10L));
        if (this.token != null) {
            request.header("X-StoryAnvil-Secret", this.token);
        }
        return this.client.sendAsync(request.build(), HttpResponse.BodyHandlers.ofString());
    }

    public void connect() {
        this.httpGet("/~belt").thenAccept(response -> {
            if (response.statusCode() != 200) {
                log.error("BELT HANDSHAKE FAILED! Invalid status code: {}", (Object)response.statusCode());
                BeltCommunications.dispose();
                return;
            }
            try {
                JsonObject handshake = JsonParser.parseString((String)((String)response.body())).getAsJsonObject();
                if (!handshake.get("successful").getAsBoolean()) {
                    if (handshake.has("message")) {
                        log.error("BELT HANDSHAKE FAILED! Server sent following message: {}", (Object)handshake.get("message").getAsString());
                    } else {
                        log.error("BELT HANDSHAKE FAILED! Server did not sent any explanation message");
                    }
                    BeltCommunications.dispose();
                    return;
                }
                this.remoteServerName = handshake.get("server").getAsString();
                this.token = handshake.get("token").getAsString();
                if (handshake.has("message")) {
                    log.warn("BELT HANDSHAKE! \"{}\" Server connected and sent following message: {}", (Object)this.remoteServerName, (Object)handshake.get("message").getAsString());
                } else {
                    log.warn("BELT HANDSHAKE! \"{}\" Server connected and did not sent any additional message", (Object)this.remoteServerName);
                }
                CogwheelExecutor.scheduleBelt(this::produceUpdateCheck, 250);
            }
            catch (JsonSyntaxException | IllegalStateException e) {
                log.error("BELT HANDSHAKE FAILED! Invalid response");
                throw new RuntimeException("BELT HANDSHAKE FAILED! Invalid response", e);
            }
        });
    }

    @NotNull
    public String getRemoteServerName() {
        if (this.remoteServerName == null) {
            return "Unknown Belt Server";
        }
        return this.remoteServerName;
    }

    public String getHost() {
        return this.host;
    }

    public String getUserLink(ServerPlayer player) {
        return this.host + "/~auth/" + Base64.getUrlEncoder().encodeToString(player.m_6302_().getBytes(StandardCharsets.UTF_8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateUpdateBody() {
        Object object = SYNC;
        synchronized (object) {
            JsonObject jo = new JsonObject();
            JsonArray array = new JsonArray();
            for (BeltPacket packet : this.packets) {
                array.add((JsonElement)packet.toJSON());
            }
            jo.add("list", (JsonElement)array);
            return jo.toString();
        }
    }

    private void produceUpdateCheck() {
        this.httpPost("/~belt/update", this.generateUpdateBody()).thenAccept(response -> {
            if (response.statusCode() == 200) {
                EventBus.beltCommunications = this;
                JsonObject obj = JsonParser.parseString((String)((String)response.body())).getAsJsonObject();
                JsonArray list = obj.get("list").getAsJsonArray();
                for (int i = 0; i < list.size(); ++i) {
                    BeltPacket packet = BeltPacket.parse(list.get(i).getAsJsonObject());
                    packet.getType().handler.accept(packet);
                }
                CogwheelExecutor.scheduleBelt(this::produceUpdateCheck, 250);
            } else {
                log.error("Update check failed. Connection will be closed");
                BeltCommunications.dispose();
            }
        });
    }

    private static void dispose() {
        EventBus.beltCommunications = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pushPacket(BeltPacket packet) {
        if (EventBus.beltCommunications != null) {
            Object object = SYNC;
            synchronized (object) {
                EventBus.beltCommunications.packets.add(packet);
            }
        }
    }
}

