/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.network.devui;

import com.storyanvil.cogwheel.CogwheelExecutor;
import com.storyanvil.cogwheel.client.devui.DevUI;
import com.storyanvil.cogwheel.client.devui.DevUIScreen;
import com.storyanvil.cogwheel.config.CogwheelConfig;
import com.storyanvil.cogwheel.data.StoryCodec;
import com.storyanvil.cogwheel.data.StoryCodecBuilder;
import com.storyanvil.cogwheel.data.StoryPacket;
import com.storyanvil.cogwheel.network.devui.DevNetwork;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public record DevEarlySyncPacket(boolean permitted, boolean silent) implements StoryPacket
{
    public static final StoryCodec<DevEarlySyncPacket> CODEC = StoryCodecBuilder.build(StoryCodecBuilder.Bool(DevEarlySyncPacket::permitted), StoryCodecBuilder.Bool(DevEarlySyncPacket::silent), DevEarlySyncPacket::new);

    public static void syncFor(ServerPlayer player, boolean silent) {
        DevNetwork.sendFromServer(player, new DevEarlySyncPacket(DevEarlySyncPacket.isDev(), silent));
    }

    public static void syncAll(boolean silent) {
        DevNetwork.sendFromServer(new DevEarlySyncPacket(DevEarlySyncPacket.isDev(), silent));
    }

    public static boolean isDev() {
        return CogwheelConfig.isDevEnvironment();
    }

    @Override
    public void onServerUnsafe(Supplier<NetworkEvent.Context> ctx) {
        DevEarlySyncPacket.syncFor(ctx.get().getSender(), this.silent);
    }

    @Override
    public void onClientUnsafe(Supplier<NetworkEvent.Context> ctx) {
        DevUI.permitted = this.permitted;
        if (!this.permitted) {
            CogwheelExecutor.scheduleTickEventClientSide(levelTickEvent -> {
                if (Minecraft.m_91087_().f_91080_ instanceof DevUIScreen) {
                    Minecraft.m_91087_().m_91152_(null);
                    Minecraft.m_91087_().m_91300_().m_94922_((Toast)new SystemToast(SystemToast.SystemToastIds.PERIODIC_NOTIFICATION, (Component)Component.m_237115_((String)"ui.storyanvil_cogwheel.notif_block"), (Component)Component.m_237115_((String)"ui.storyanvil_cogwheel.notif_block_msg")));
                }
            });
        }
        if (!this.silent) {
            Minecraft.m_91087_().m_91300_().m_94922_((Toast)new SystemToast(SystemToast.SystemToastIds.PERIODIC_NOTIFICATION, (Component)Component.m_237115_((String)"ui.storyanvil_cogwheel.notif_sync"), (Component)Component.m_237115_((String)"ui.storyanvil_cogwheel.notif_sync_msg")));
        }
    }

    @Override
    public String toString() {
        return "DevEarlySyncPacket{permitted=" + this.permitted + ", silent=" + this.silent + "}";
    }
}

