/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.network.devui;

import com.storyanvil.cogwheel.client.devui.DWCodeEditor;
import com.storyanvil.cogwheel.data.StoryCodec;
import com.storyanvil.cogwheel.data.StoryCodecBuilder;
import com.storyanvil.cogwheel.data.StoryCodecs;
import com.storyanvil.cogwheel.data.StoryPacket;
import com.storyanvil.cogwheel.network.devui.editor.DevEditorSession;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;

public record DevEditorState(ResourceLocation lc, Byte state) implements StoryPacket
{
    public static final StoryCodec<DevEditorState> CODEC = StoryCodecBuilder.build(StoryCodecBuilder.Prop(DevEditorState::lc, StoryCodecs.RESOURCE_LOC), StoryCodecBuilder.Byte(DevEditorState::state), DevEditorState::new);

    @Override
    public void onServerUnsafe(Supplier<NetworkEvent.Context> ctx) {
        DevEditorSession session = DevEditorSession.get(this.lc);
        if (session == null) {
            this.error(ctx.get().getSender(), "Invalid session!");
            return;
        }
        if (this.state == -128) {
            session.closeConnection(ctx.get());
            return;
        }
        if (this.state == -127) {
            session.resync(ctx.get().getSender());
            return;
        }
    }

    @Override
    public void onClientUnsafe(Supplier<NetworkEvent.Context> ctx) {
        if (this.state == -128) {
            DWCodeEditor editor = DWCodeEditor.get(this.lc);
            if (editor == null) {
                return;
            }
            DWCodeEditor.delete(this.lc);
            Minecraft.m_91087_().m_91300_().m_94922_((Toast)new SystemToast(SystemToast.SystemToastIds.PERIODIC_NOTIFICATION, (Component)Component.m_237113_((String)"Server change!"), (Component)Component.m_237113_((String)"Server closed your edition session!")));
        }
    }

    @Override
    public String toString() {
        return "DevEditorState{lc=" + String.valueOf(this.lc) + ", state=" + this.state + "}";
    }
}

