/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.network.devui;

import com.storyanvil.cogwheel.data.StoryCodec;
import com.storyanvil.cogwheel.data.StoryPacket;
import com.storyanvil.cogwheel.network.devui.DevConsoleCode;
import com.storyanvil.cogwheel.network.devui.DevDeleteLine;
import com.storyanvil.cogwheel.network.devui.DevEarlySyncPacket;
import com.storyanvil.cogwheel.network.devui.DevEditorLine;
import com.storyanvil.cogwheel.network.devui.DevEditorState;
import com.storyanvil.cogwheel.network.devui.DevEditorUserDelta;
import com.storyanvil.cogwheel.network.devui.DevEnterCallback;
import com.storyanvil.cogwheel.network.devui.DevFlush;
import com.storyanvil.cogwheel.network.devui.DevInsertLine;
import com.storyanvil.cogwheel.network.devui.DevOpenFile;
import com.storyanvil.cogwheel.network.devui.DevOpenViewer;
import com.storyanvil.cogwheel.network.devui.DevResyncRequest;
import com.storyanvil.cogwheel.network.devui.DevRunAndFlush;
import com.storyanvil.cogwheel.network.devui.DevTypeCallback;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DevNetwork {
    public static final Logger log = LoggerFactory.getLogger((String)"STORYANVIL/COGWHEEL/NETWORK");
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel DEV_BRIDGE = NetworkRegistry.newSimpleChannel((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"storyanvil_cogwheel", (String)"dev-bridge"), () -> "1", "1"::equals, "1"::equals);
    private static final AtomicInteger PACKET_ID = new AtomicInteger(0);

    public static void init() {
        DevNetwork.register(DevEarlySyncPacket.class, DevEarlySyncPacket.CODEC);
        DevNetwork.register(DevConsoleCode.class, DevConsoleCode.CODEC);
        DevNetwork.register(DevOpenFile.class, DevOpenFile.CODEC);
        DevNetwork.register(DevEditorLine.class, DevEditorLine.CODEC);
        DevNetwork.register(DevEditorState.class, DevEditorState.CODEC);
        DevNetwork.register(DevEditorUserDelta.class, DevEditorUserDelta.CODEC);
        DevNetwork.register(DevResyncRequest.class, DevResyncRequest.CODEC);
        DevNetwork.register(DevTypeCallback.class, DevTypeCallback.CODEC);
        DevNetwork.register(DevFlush.class, DevFlush.CODEC);
        DevNetwork.register(DevRunAndFlush.class, DevRunAndFlush.CODEC);
        DevNetwork.register(DevOpenViewer.class, DevOpenViewer.CODEC);
        DevNetwork.register(DevEnterCallback.class, DevEnterCallback.CODEC);
        DevNetwork.register(DevInsertLine.class, DevInsertLine.CODEC);
        DevNetwork.register(DevDeleteLine.class, DevDeleteLine.CODEC);
    }

    private static <T extends StoryPacket> void register(@NotNull Class<T> clazz, @NotNull StoryCodec<T> codec) {
        DEV_BRIDGE.registerMessage(PACKET_ID.incrementAndGet(), clazz, codec.encoder(), codec.decoder(), StoryPacket::handle);
    }

    public static void sendToServer(StoryPacket msg) {
        if (msg == null) {
            return;
        }
        DEV_BRIDGE.sendToServer((Object)msg);
    }

    public static void sendFromServer(StoryPacket msg) {
        if (msg == null) {
            return;
        }
        DEV_BRIDGE.send(PacketDistributor.ALL.noArg(), (Object)msg);
    }

    public static void sendFromServer(ServerPlayer plr, StoryPacket msg) {
        if (msg == null) {
            return;
        }
        DEV_BRIDGE.send(PacketDistributor.PLAYER.with(() -> plr), (Object)msg);
    }
}

