/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.network.devui.editor;

import com.storyanvil.cogwheel.CogwheelExecutor;
import com.storyanvil.cogwheel.data.SyncArray;
import com.storyanvil.cogwheel.infrastructure.env.CogScriptEnvironment;
import com.storyanvil.cogwheel.network.devui.DevDeleteLine;
import com.storyanvil.cogwheel.network.devui.DevEditorLine;
import com.storyanvil.cogwheel.network.devui.DevEditorState;
import com.storyanvil.cogwheel.network.devui.DevEditorUserDelta;
import com.storyanvil.cogwheel.network.devui.DevEnterCallback;
import com.storyanvil.cogwheel.network.devui.DevInsertLine;
import com.storyanvil.cogwheel.network.devui.DevNetwork;
import com.storyanvil.cogwheel.network.devui.DevOpenFile;
import com.storyanvil.cogwheel.network.devui.DevTypeCallback;
import com.storyanvil.cogwheel.network.devui.editor.DevEditorUser;
import com.storyanvil.cogwheel.network.mc.CogwheelPacketHandler;
import com.storyanvil.cogwheel.network.mc.Notification;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class DevEditorSession {
    private static final HashMap<ResourceLocation, DevEditorSession> sessions = new HashMap();
    private static final HashMap<String, Integer> cursorColors = new HashMap();
    private static final AtomicInteger currentColor = new AtomicInteger(0);
    private static final int[] COLORS = new int[]{-922812416, -922790912, -922748160, -932643072, -939458643, -939495199, -935890719, -923664159};
    private CogScriptEnvironment env;
    protected ResourceLocation lc;
    private File file;
    protected SyncArray<String> lines = new SyncArray();
    protected ArrayList<DevEditorUser> connections = new ArrayList();

    public static synchronized void boundColorFor(ServerPlayer plr) {
        cursorColors.put(plr.m_6302_(), COLORS[currentColor.get()]);
        if (currentColor.addAndGet(1) >= COLORS.length) {
            currentColor.set(0);
        }
    }

    public static synchronized void unboundColorFrom(ServerPlayer plr) {
        cursorColors.remove(plr.m_6302_());
    }

    public static int getColorFor(ServerPlayer plr) {
        return cursorColors.get(plr.m_6302_());
    }

    public static DevEditorSession createOrGet(ResourceLocation lc) {
        if (sessions.containsKey(lc)) {
            return sessions.get(lc);
        }
        DevEditorSession session = new DevEditorSession(lc);
        sessions.put(lc, session);
        return session;
    }

    public static DevEditorSession get(ResourceLocation lc) {
        return sessions.get(lc);
    }

    public static Collection<DevEditorSession> getSessions() {
        return sessions.values();
    }

    private DevEditorSession(ResourceLocation lc) {
        this.lc = lc;
        this.file = CogScriptEnvironment.getScriptFile(lc);
        this.env = CogScriptEnvironment.getEnvironment(lc);
        CogwheelExecutor.log.info("Created EditorSession for {}({})", (Object)this.file, (Object)lc);
    }

    public synchronized void resyncAll() {
        for (int i = 0; i < this.connections.size(); ++i) {
            DevEditorUser con = this.connections.get(i);
            if (con.isInvalid()) {
                this.connections.remove(--i);
                con.dispose();
                continue;
            }
            this.resync(con);
        }
    }

    public synchronized void resync(DevEditorUser con) {
        int i;
        for (i = 0; i < this.lines.size(); ++i) {
            DevNetwork.sendFromServer(con.get(), new DevEditorLine(this.lc, i, this.lines.get(i), this.lines.size()));
        }
        for (i = 0; i < this.connections.size(); ++i) {
            DevEditorUser con2 = this.connections.get(i);
            if (con2.isInvalid()) {
                this.connections.remove(--i);
                continue;
            }
            DevNetwork.sendFromServer(con.get(), con2.toDelta());
        }
    }

    public synchronized void read() throws IOException {
        if (!this.env.canBeEdited()) {
            throw new IOException("Scripts in environment \"" + this.env.toString() + "\" does not allow script editing");
        }
        if (!this.file.exists()) {
            this.lines.clear();
            this.lines.add("");
            this.resyncAll();
            return;
        }
        try (FileReader fr = new FileReader(this.file);
             Scanner sc = new Scanner(fr);){
            this.lines.clear();
            while (sc.hasNextLine()) {
                this.lines.add(sc.nextLine());
            }
            this.resyncAll();
        }
    }

    public synchronized void dispose() {
        for (DevEditorUser con : this.connections) {
            con.dispose();
        }
        this.connections.clear();
        this.connections = null;
        this.lines.clear();
        this.lines = null;
        sessions.remove(this.lc);
        CogwheelExecutor.log.info("Disposed EditorSession for {}({})", (Object)this.file, (Object)this.lc);
        this.lc = null;
        this.file = null;
    }

    public synchronized void addConnection(ServerPlayer plr) {
        DevEditorUser con = new DevEditorUser(this, plr);
        this.connections.add(con);
        DevNetwork.sendFromServer(plr, new DevOpenFile(this.lc));
        con.setColor(DevEditorSession.getColorFor(plr));
    }

    public synchronized void closeConnection(NetworkEvent.Context ctx) {
        DevEditorUser con = this.getConnection(ctx.getSender());
        if (con == null) {
            return;
        }
        this.connections.remove(con);
        con.dispose();
        this.resyncAll();
        if (this.connections.isEmpty()) {
            this.dispose();
        }
    }

    private synchronized DevEditorUser getConnection(ServerPlayer plr) {
        for (int i = 0; i < this.connections.size(); ++i) {
            DevEditorUser con = this.connections.get(i);
            if (con.refersTo(plr)) {
                return con;
            }
            if (!con.isInvalid()) continue;
            this.connections.remove(i);
            --i;
            con.dispose();
        }
        return null;
    }

    public synchronized void resync(@Nullable ServerPlayer sender) {
        if (sender == null) {
            return;
        }
        DevEditorUser con = this.getConnection(sender);
        if (con == null) {
            return;
        }
        this.resync(con);
    }

    public synchronized void updateConnection(@Nullable ServerPlayer sender, DevEditorUserDelta delta) {
        DevEditorUser user = this.getConnection(sender);
        if (user == null) {
            if (sender != null) {
                DevNetwork.sendFromServer(sender, new DevEditorState(this.lc, (byte)-128));
            }
            return;
        }
        user.setLine(delta.line());
        user.setPos(delta.line());
        user.setSelectedChars(delta.selected());
        DevEditorUserDelta safeDelta = user.toDelta();
        for (int i = 0; i < this.connections.size(); ++i) {
            DevEditorUser con = this.connections.get(i);
            if (con == user) {
                return;
            }
            if (con.isInvalid()) {
                this.connections.remove(--i);
                con.dispose();
                continue;
            }
            DevNetwork.sendFromServer(con.get(), safeDelta);
        }
    }

    public synchronized void typeCallback(@Nullable ServerPlayer sender, DevTypeCallback callback) {
        DevEditorUser user = this.getConnection(sender);
        if (user == null) {
            if (sender != null) {
                DevNetwork.sendFromServer(sender, new DevEditorState(this.lc, (byte)-128));
            }
            return;
        }
        user.applyDelta(callback.delta());
        if (user.getPos() <= 0 && callback.typed().equals("<backspace>")) {
            if (user.getLine() <= 0) {
                return;
            }
            user.setPos(0);
            DevDeleteLine delta1 = new DevDeleteLine(this.lc, user.getLine());
            int last = user.getLine() - 1;
            String line = this.lines.get(last) + this.lines.get(user.getLine());
            DevEditorLine delta2 = new DevEditorLine(this.lc, last, line, this.lines.size() - 1);
            user.setLine(user.getLine() - 1);
            user.setPos(line.length() + 1);
            DevEditorUserDelta delta = user.toDelta();
            this.lines.remove(user.getLine());
            this.lines.set(last, line);
            for (int i = 0; i < this.connections.size(); ++i) {
                DevEditorUser con = this.connections.get(i);
                if (con.isInvalid()) {
                    this.connections.remove(--i);
                    continue;
                }
                ServerPlayer plr = con.get();
                DevNetwork.sendFromServer(plr, delta);
                DevNetwork.sendFromServer(plr, delta1);
                DevNetwork.sendFromServer(plr, delta2);
            }
            return;
        }
        StringBuilder diff = new StringBuilder(this.lines.get(user.getLine()));
        if (callback.typed().equals("<backspace>")) {
            if (user.getPos() <= 0) {
                return;
            }
            diff.deleteCharAt(user.getPos() - 1);
            user.setPos(user.getPos() - 1);
        } else if (callback.typed().equals("<delete>")) {
            if (user.getPos() < 0) {
                return;
            }
            diff.deleteCharAt(user.getPos());
        } else if (diff.isEmpty()) {
            diff.append(callback.typed());
            user.setPos(user.getPos() + callback.typed().length() + 1);
        } else {
            diff.insert(user.getPos(), callback.typed());
            user.setPos(user.getPos() + 1);
        }
        this.lines.set(user.getLine(), diff.toString());
        DevEditorUserDelta safeDelta = user.toDelta();
        DevEditorLine lineDelta = new DevEditorLine(this.lc, user.getLine(), diff.toString(), this.lines.size());
        for (int i = 0; i < this.connections.size(); ++i) {
            DevEditorUser con = this.connections.get(i);
            if (con.isInvalid()) {
                this.connections.remove(--i);
                continue;
            }
            ServerPlayer plr = con.get();
            DevNetwork.sendFromServer(plr, lineDelta);
            DevNetwork.sendFromServer(plr, safeDelta);
        }
    }

    public synchronized void flush(@Nullable ServerPlayer sender) {
        try {
            if (!this.file.exists()) {
                this.file.createNewFile();
            }
            try (FileWriter fw = new FileWriter(this.file);){
                for (String line : this.lines) {
                    fw.append(line).append('\n');
                }
                fw.flush();
                for (int i = 0; i < this.connections.size(); ++i) {
                    DevEditorUser con = this.connections.get(i);
                    if (con.isInvalid()) {
                        this.connections.remove(--i);
                        continue;
                    }
                    ServerPlayer plr = con.get();
                    CogwheelPacketHandler.DELTA_BRIDGE.send(PacketDistributor.PLAYER.with(() -> plr), (Object)new Notification((Component)Component.m_237113_((String)"File saved"), (Component)Component.m_237113_((String)("File " + String.valueOf(this.lc) + " was saved!"))));
                }
            }
        }
        catch (Exception e) {
            CogwheelExecutor.log.error("Exception while flushing {}: {}", (Object)this.file, (Object)e);
            CogwheelPacketHandler.DELTA_BRIDGE.send(PacketDistributor.PLAYER.with(() -> sender), (Object)new Notification((Component)Component.m_237113_((String)"Save failed"), (Component)Component.m_237113_((String)("File " + String.valueOf(this.lc) + " was not saved!"))));
        }
    }

    public void dispatch() {
        CogwheelExecutor.schedule(() -> CogScriptEnvironment.dispatchScriptGlobal(this.lc));
    }

    public synchronized void flushAndDispatch(@Nullable ServerPlayer sender) {
        try (FileWriter fw = new FileWriter(this.file);){
            for (String line : this.lines) {
                fw.append(line).append('\n');
            }
            fw.flush();
            for (int i = 0; i < this.connections.size(); ++i) {
                DevEditorUser con = this.connections.get(i);
                if (con.isInvalid()) {
                    this.connections.remove(--i);
                    continue;
                }
                ServerPlayer plr = con.get();
                this.dispatch();
                CogwheelPacketHandler.DELTA_BRIDGE.send(PacketDistributor.PLAYER.with(() -> plr), (Object)new Notification((Component)Component.m_237113_((String)"File saved and executed!"), (Component)Component.m_237113_((String)("File " + String.valueOf(this.lc) + " was saved!"))));
            }
        }
        catch (Exception e) {
            CogwheelExecutor.log.error("Exception while flushing {}: {}", (Object)this.file, (Object)e);
            CogwheelPacketHandler.DELTA_BRIDGE.send(PacketDistributor.PLAYER.with(() -> sender), (Object)new Notification((Component)Component.m_237113_((String)"Save failed"), (Component)Component.m_237113_((String)("File " + String.valueOf(this.lc) + " was not saved!"))));
        }
    }

    public synchronized void typeCallback(@Nullable ServerPlayer sender, DevEnterCallback callback) {
        if (callback.typed().equals("enter")) {
            DevInsertLine delta1;
            DevEditorUser user = this.getConnection(sender);
            if (user == null) {
                if (sender != null) {
                    DevNetwork.sendFromServer(sender, new DevEditorState(this.lc, (byte)-128));
                }
                return;
            }
            DevEditorLine delta2 = null;
            user.applyDelta(callback.delta());
            String line = this.lines.get(user.getLine());
            if (user.getPos() == line.length() + 1) {
                delta1 = new DevInsertLine(this.lc, user.getLine(), "");
            } else {
                delta1 = new DevInsertLine(this.lc, user.getLine(), line.substring(user.getPos()));
                delta2 = new DevEditorLine(this.lc, user.getLine(), line.substring(0, user.getPos()), this.lines.size() + 1);
            }
            this.lines.add(delta1.lineBefore() + 1, delta1.contents());
            if (delta2 != null) {
                this.lines.set(delta2.lineNumber(), delta2.line());
            }
            user.setLine(user.getLine() + 1);
            user.setPos(0);
            DevEditorUserDelta delta3 = user.toDelta();
            for (int i = 0; i < this.connections.size(); ++i) {
                DevEditorUser con = this.connections.get(i);
                if (con.isInvalid()) {
                    this.connections.remove(--i);
                    continue;
                }
                ServerPlayer plr = con.get();
                DevNetwork.sendFromServer(plr, delta1);
                DevNetwork.sendFromServer(plr, delta2);
                DevNetwork.sendFromServer(plr, delta3);
            }
        }
    }
}

