/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.network.devui.editor;

import com.storyanvil.cogwheel.network.devui.DevEditorState;
import com.storyanvil.cogwheel.network.devui.DevEditorUserDelta;
import com.storyanvil.cogwheel.network.devui.DevNetwork;
import com.storyanvil.cogwheel.network.devui.editor.DevEditorSession;
import java.lang.ref.WeakReference;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

public class DevEditorUser {
    private DevEditorSession session;
    private WeakReference<ServerPlayer> player;
    private int line = 0;
    private int pos = 0;
    private int selectedChars = 0;
    private int color = 0;

    public DevEditorUser(DevEditorSession session, @NotNull ServerPlayer player) {
        if (player == null) {
            throw new IllegalStateException("Player is null");
        }
        this.session = session;
        this.player = new WeakReference<ServerPlayer>(player);
    }

    public boolean isInvalid() {
        return this.player.refersTo(null);
    }

    public void dispose() {
        ServerPlayer plr = (ServerPlayer)this.player.get();
        if (plr != null) {
            DevNetwork.sendFromServer(plr, new DevEditorState(this.session.lc, (byte)-128));
            plr = null;
        }
        this.session = null;
        this.player.clear();
        this.player = null;
    }

    public boolean refersTo(ServerPlayer plr) {
        return this.player.refersTo(plr);
    }

    public ServerPlayer get() {
        return (ServerPlayer)this.player.get();
    }

    public DevEditorUserDelta toDelta() {
        return new DevEditorUserDelta(this.session.lc, this.line, this.pos, this.selectedChars, ((ServerPlayer)this.player.get()).m_6302_(), this.color);
    }

    public void applyDelta(DevEditorUserDelta delta) {
        this.pos = delta.pos();
        this.line = delta.line();
        this.selectedChars = delta.selected();
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        if (line < 0) {
            this.line = 0;
            return;
        }
        this.line = line;
    }

    public int getPos() {
        return this.pos;
    }

    public void setPos(int pos) {
        if (pos <= 0) {
            this.pos = 0;
            return;
        }
        this.pos = pos;
    }

    public int getSelectedChars() {
        return this.selectedChars;
    }

    public void setSelectedChars(int selectedChars) {
        this.selectedChars = selectedChars;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }
}

