/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.network.mc;

import com.storyanvil.cogwheel.CogwheelExecutor;
import com.storyanvil.cogwheel.client.devui.DevTab;
import com.storyanvil.cogwheel.network.mc.CogwheelPacketHandler;
import com.storyanvil.cogwheel.network.mc.Notification;
import com.storyanvil.cogwheel.util.StoryUtils;
import java.io.File;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class DevBoundRequest {
    @NotNull
    private String type;
    @NotNull
    private String data;

    @Contract(pure=true)
    public DevBoundRequest() {
        this.type = "";
        this.data = "";
    }

    @Contract(pure=true)
    public DevBoundRequest(@NotNull String type) {
        this.type = type;
        this.data = "";
    }

    @Contract(pure=true)
    public DevBoundRequest(@NotNull String type, @NotNull String data) {
        this.type = type;
        this.data = data;
    }

    @NotNull
    public String getType() {
        return this.type;
    }

    public void encode(@NotNull FriendlyByteBuf friendlyByteBuf) {
        StoryUtils.encodeString(friendlyByteBuf, this.type);
        StoryUtils.encodeString(friendlyByteBuf, this.data);
    }

    @NotNull
    public static DevBoundRequest decode(FriendlyByteBuf friendlyByteBuf) {
        DevBoundRequest bound = new DevBoundRequest();
        bound.type = StoryUtils.decodeString(friendlyByteBuf);
        bound.data = StoryUtils.decodeString(friendlyByteBuf);
        return bound;
    }

    public void handle(@NotNull Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            try {
                boolean server = ((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isServer();
                CogwheelExecutor.log.debug("[DevUI Bound] {} | For server: {}", (Object)this, (Object)server);
                switch (this.type) {
                    case "full": {
                        if (!server) break;
                        this.files(ctx, true);
                        if (this.data.equals("silent")) break;
                        CogwheelPacketHandler.DELTA_BRIDGE.send(PacketDistributor.PLAYER.with(() -> DevBoundRequest.lambda$handle$0((Supplier)ctx)), (Object)new Notification((Component)Component.m_237115_((String)"ui.storyanvil_cogwheel.notif_sync"), (Component)Component.m_237115_((String)"ui.storyanvil_cogwheel.notif_sync_msg")));
                        break;
                    }
                    case "files": {
                        this.files(ctx, server);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public void files(@NotNull Supplier<NetworkEvent.Context> ctx, boolean server) {
        if (server) {
            File[] files = new File(Minecraft.m_91087_().f_91069_, "config/cog").listFiles();
            StringBuilder sb = new StringBuilder();
            if (files != null) {
                for (File f : files) {
                    sb.append("|").append(f.getName());
                }
            }
            String d = sb.toString().substring(1);
            CogwheelExecutor.scheduleTickEvent(t -> CogwheelPacketHandler.DELTA_BRIDGE.send(PacketDistributor.PLAYER.with(() -> DevBoundRequest.lambda$files$2((Supplier)ctx)), (Object)new DevBoundRequest("files", d)));
        } else {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
                DevTab.FileSelector.files = ("Create new file|" + this.data).split("\\|");
            });
        }
    }

    public String toString() {
        return "DevBoundRequest{type='" + this.type + "', data='" + this.data + "'}";
    }

    private static /* synthetic */ ServerPlayer lambda$files$2(Supplier ctx) {
        return ((NetworkEvent.Context)ctx.get()).getSender();
    }

    private static /* synthetic */ ServerPlayer lambda$handle$0(Supplier ctx) {
        return ((NetworkEvent.Context)ctx.get()).getSender();
    }
}

