/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.util;

import com.storyanvil.cogwheel.api.Api;
import com.storyanvil.cogwheel.infrastructure.ArgumentData;
import com.storyanvil.cogwheel.infrastructure.CogPropertyManager;
import com.storyanvil.cogwheel.infrastructure.cog.CogBool;
import com.storyanvil.cogwheel.infrastructure.cog.CogInvoker;
import com.storyanvil.cogwheel.infrastructure.cog.PropertyHandler;
import com.storyanvil.cogwheel.infrastructure.script.DispatchedScript;
import com.storyanvil.cogwheel.util.PropertyLocation;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Api.Internal
@ApiStatus.Internal
public class EasyPropManager {
    public static final HashMap<String, PropertyHandler> allHandlers = new HashMap();
    private final String manager;
    private final WeakReference<HashMap<String, PropertyHandler>> handlers;

    public static void defaultMethods(@NotNull HashMap<String, PropertyHandler> handlers) {
        handlers.put(PropertyLocation.fromNamespaceAndPath("any", "toString"), (name, args, script, o) -> ((CogPropertyManager)o).convertToCogString());
        handlers.put(PropertyLocation.fromNamespaceAndPath("any", "equals"), (name, args, script, o) -> CogBool.getInstance(((CogPropertyManager)o).equalsTo(args.get(0))));
        handlers.put(PropertyLocation.fromNamespaceAndPath("any", "asInvoker"), (name, args, script, o) -> {
            CogPropertyManager m = (CogPropertyManager)o;
            return CogInvoker.genericInvoker(m, args.getString(0));
        });
    }

    @Api.Internal
    @ApiStatus.Internal
    public EasyPropManager(String manager, @NotNull Registrar registrar) {
        this.manager = manager;
        this.handlers = new WeakReference<HashMap<String, PropertyHandler>>(allHandlers);
        registrar.register(this);
    }

    @Api.Internal
    @ApiStatus.Internal
    public EasyPropManager(String manager, @NotNull Registrar registrar, @NotNull HashMap<String, PropertyHandler> h) {
        this.manager = manager;
        this.handlers = new WeakReference<HashMap<String, PropertyHandler>>(h);
        registrar.register(this);
    }

    @Api.Internal
    @ApiStatus.Internal
    public boolean hasOwnProperty(String name) {
        return ((HashMap)this.handlers.get()).containsKey(PropertyLocation.fromNamespaceAndPath(this.manager, name)) || ((HashMap)this.handlers.get()).containsKey(PropertyLocation.fromNamespaceAndPath("any", name));
    }

    @Api.Internal
    @ApiStatus.Internal
    public boolean hasOwnProperty(String name, Function<String, Boolean> alt) {
        return this.hasOwnProperty(name) || alt.apply(name) != false;
    }

    @Api.Internal
    @ApiStatus.Internal
    public PropertyHandler get(String name) {
        PropertyHandler h = (PropertyHandler)((HashMap)this.handlers.get()).get(PropertyLocation.fromNamespaceAndPath(this.manager, name));
        if (h != null) {
            return h;
        }
        return (PropertyHandler)((HashMap)this.handlers.get()).get(PropertyLocation.fromNamespaceAndPath("any", name));
    }

    @Api.Internal
    @ApiStatus.Internal
    public PropertyHandler get(String name, Function<String, PropertyHandler> alt) {
        PropertyHandler h = this.get(name);
        if (h != null) {
            return h;
        }
        return alt.apply(name);
    }

    @Api.Internal
    @ApiStatus.Internal
    public CogPropertyManager get(String name, ArgumentData args, DispatchedScript script, Object o) {
        PropertyHandler h = this.get(name);
        return h.handle(name, args, script, o);
    }

    @Api.Internal
    @ApiStatus.Internal
    public CogPropertyManager get(String name, ArgumentData args, DispatchedScript script, Object o, Supplier<CogPropertyManager> alt) {
        PropertyHandler h = this.get(name);
        if (h != null) {
            return h.handle(name, args, script, o);
        }
        return alt.get();
    }

    @Api.Internal
    @ApiStatus.Internal
    public void reg(String name, PropertyHandler handler) {
        ((HashMap)this.handlers.get()).put(PropertyLocation.fromNamespaceAndPath(this.manager, name), handler);
    }

    static {
        EasyPropManager.defaultMethods(allHandlers);
    }

    @Api.Internal
    @ApiStatus.Internal
    public static interface Registrar {
        @Api.Internal
        @ApiStatus.Internal
        public void register(EasyPropManager var1);
    }
}

