/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.util;

import com.storyanvil.cogwheel.api.Api;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.jetbrains.annotations.NotNull;

@Api.Stable(since="2.0.0")
public class WeakList<T>
implements List<T> {
    private final ArrayList<WeakReference<T>> list = new ArrayList();

    @Api.Stable(since="2.0.0")
    public WeakList() {
    }

    @Api.Stable(since="2.0.0")
    public WeakList(T value) {
        this();
        this.add(value);
    }

    @Override
    @Api.Stable(since="2.0.0")
    public int size() {
        return this.list.size();
    }

    @Override
    @Api.Stable(since="2.0.0")
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Api.Stable(since="2.0.0")
    public void cleanUp() {
        for (int i = 0; i < this.list.size(); ++i) {
            WeakReference<Object> ref = this.list.get(i);
            if (!ref.refersTo(null)) continue;
            this.list.remove(i);
            --i;
        }
    }

    @Override
    @Api.Stable(since="2.0.0")
    public boolean contains(Object o) {
        for (int i = 0; i < this.list.size(); ++i) {
            WeakReference<Object> ref = this.list.get(i);
            if (ref.refersTo(null)) {
                this.list.remove(i);
                --i;
                continue;
            }
            if (!ref.refersTo(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public @NotNull Object @NotNull [] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public <T1> @NotNull T1 @NotNull [] toArray(@NotNull @NotNull T1 @NotNull [] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Api.Stable(since="2.0.0")
    public boolean add(T t) {
        return this.list.add(new WeakReference<T>(t));
    }

    @Override
    @Api.Stable(since="2.0.0")
    public boolean remove(Object o) {
        for (int i = 0; i < this.list.size(); ++i) {
            WeakReference<Object> t = this.list.get(i);
            if (t.refersTo(null)) {
                this.list.remove(--i);
                continue;
            }
            if (!t.refersTo(o)) continue;
            this.list.remove(--i);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, @NotNull Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Api.Stable(since="2.0.0")
    public void clear() {
        this.list.clear();
    }

    @Override
    @Api.Stable(since="2.0.0")
    public T get(int index) {
        return this.list.get(index).get();
    }

    @Api.Stable(since="2.0.0")
    public WeakReference<T> getRef(int index) {
        return this.list.get(index);
    }

    @Override
    @Api.Stable(since="2.0.0")
    public T set(int index, T element) {
        return this.list.set(index, new WeakReference<T>(element)).get();
    }

    @Override
    @Api.Stable(since="2.0.0")
    public void add(int index, T element) {
        this.list.add(index, new WeakReference<T>(element));
    }

    @Override
    @Api.Stable(since="2.0.0")
    public T remove(int index) {
        return this.list.remove(index).get();
    }

    @Override
    public int indexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public ListIterator<T> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public ListIterator<T> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public List<T> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }
}

