/*
 *
 * StoryAnvil Cogwheel Engine
 * Copyright (C) 2025 StoryAnvil
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU Lesser General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.storyanvil.cogwheel.fabric;

import com.storyanvil.cogwheel.CogwheelHooks;
import com.storyanvil.cogwheel.data.StoryPacket;
import com.storyanvil.cogwheel.fabric.client.CogwheelEngineFabricClient;
import com.storyanvil.cogwheel.fabric.client.NPCModel;
import com.storyanvil.cogwheel.fabric.data.StoryFabricParcel;
import com.storyanvil.cogwheel.infrastructure.CGPM;
import com.storyanvil.cogwheel.infrastructure.cog.CogPrimalType;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_3222;
import java.io.File;

public class CogwheelHooksImpl {
    public static File getConfigFolder() {
        return FabricLoader.getInstance().getConfigDir().toFile();
    }

    public static byte performVersionCheck() {
        CogwheelEngineFabric.PLATFORM_LOG.info("Version checker is not available on fabric");
        return 0;
    }

    public static CGPM getLevelData(String key) {
        throw new AssertionError();
    }


    public static void putLevelData(String key, CogPrimalType value) {
        throw new AssertionError();
    }

    public static <T extends StoryPacket<T>> void sendPacket(StoryPacket<T> packet, class_3222 plr) {
        ServerPlayNetworking.send(plr, new StoryFabricParcel<T>(packet.getAsData()));
    }
    public static <T extends StoryPacket<T>> void sendPacketToServer(StoryPacket<T> packet) {
        ClientPlayNetworking.send(new StoryFabricParcel<T>(packet.getAsData()));
    }
    public static <T extends StoryPacket<T>> void sendPacketToEveryone(StoryPacket<T> packet) {
        StoryFabricParcel<T> parcel = new StoryFabricParcel<T>(packet.getAsData());
        for (class_3222 plr : CogwheelHooks.getOverworldServer().method_8503().method_3760().method_14571()) {
            ServerPlayNetworking.send(plr, parcel);
        }
    }

    public static class_304 getDevUIBind() {
        return CogwheelEngineFabricClient.devUI;
    }

    public static class_1792 getInspectorItem() {
        return FabricRegistry.INSPECTOR;
    }

    public static void setAnimationData(class_2960[] locations) {
        NPCModel.animationSources = locations;
    }

    public static void startupMessage(String message) {
        CogwheelEngineFabric.PLATFORM_LOG.info("STARTUP - {}", message);
    }
}
