/*
 *
 * StoryAnvil Cogwheel Engine
 * Copyright (C) 2025 StoryAnvil
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU Lesser General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.storyanvil.cogwheel.fabric;

import com.storyanvil.cogwheel.CogwheelEngine;
import com.storyanvil.cogwheel.entity.NPC;
import com.storyanvil.cogwheel.items.InspectorItem;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_10130;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1792;
import net.minecraft.class_1814;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9334;

public class FabricRegistry {
    public static final class_1792 INSPECTOR = register("inspector", InspectorItem::new,
            new class_1792.class_1793().method_7889(1).method_24359().method_7894(class_1814.field_8904).method_57349(class_9334.field_53966, new class_10130(0.25f, Optional.of(class_2960.method_60655(CogwheelEngine.MODID, "devtools")))));

    public static final class_1299<NPC> NPC = register("npc", () ->
            class_1299.class_1300.method_5903(NPC::new, class_1311.field_17715).method_17687(0.6f, 1.8f));

    public static class_1792 register(String name, Function<class_1792.class_1793, class_1792> itemFactory, class_1792.class_1793 settings) {
        class_5321<class_1792> itemKey = class_5321.method_29179(class_7924.field_41197, class_2960.method_60655(CogwheelEngine.MODID, name));
        class_1792 item = itemFactory.apply(settings.method_63686(itemKey));
        class_2378.method_39197(class_7923.field_41178, itemKey, item);
        return item;
    }
    public static <T extends class_1297> class_1299<T> register(String name, Supplier<class_1299.class_1300<T>> sup) {
        class_5321<class_1299<?>> key = class_5321.method_29179(class_7924.field_41266, class_2960.method_60655(CogwheelEngine.MODID, "npc"));
        class_1299<?> tp = sup.get().method_5905(key);;
        return (class_1299<T>) class_2378.method_39197(class_7923.field_41177, key, tp);
    }
    public static void initialize() {/* Used to run static initializer */}
}
