/*
 *
 * StoryAnvil Cogwheel Engine
 * Copyright (C) 2025 StoryAnvil
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU Lesser General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.storyanvil.cogwheel.fabric.data;

import com.storyanvil.cogwheel.data.IStoryPacketContext;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class StoryFabricContext implements IStoryPacketContext {
    private final class_3222 sender;
    public StoryFabricContext(ClientPlayNetworking.Context ctx) {
        this.sender = null;
    }

    public StoryFabricContext(ServerPlayNetworking.Context ctx) {
        this.sender = ctx.player();
    }

    @Override
    public @Nullable class_3222 getSender() {
        return sender;
    }
}
