/*
 *
 * StoryAnvil Cogwheel Engine
 * Copyright (C) 2025 StoryAnvil
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU Lesser General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.storyanvil.cogwheel.fabric.data;

import com.storyanvil.cogwheel.CogwheelEngine;
import com.storyanvil.cogwheel.CogwheelExecutor;
import com.storyanvil.cogwheel.CogwheelHooks;
import com.storyanvil.cogwheel.data.StoryCodec;
import com.storyanvil.cogwheel.data.StoryPacket;
import com.storyanvil.cogwheel.fabric.CogwheelEngineFabric;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public class StoryFabricPacket<T extends StoryPacket<T>> implements class_9139<class_2540, StoryFabricParcel<T>> {
    private final StoryCodec<T> parent;
    private final class_8710.class_9155<class_2540, StoryFabricParcel<T>> type;

    public StoryFabricPacket(@NotNull String id, @NotNull StoryCodec<T> parent) {
        this.parent = parent;
        this.type = new class_8710.class_9155<>(new class_8710.class_9154<StoryFabricParcel<T>>(class_2960.method_60655(CogwheelEngine.MODID, id)), this);
        parent.setPlatformData(this);
    }

    @Override
    public StoryFabricParcel<T> decode(class_2540 buf) {
        return new StoryFabricParcel<>(parent.decode(buf));
    }

    @Override
    public void encode(class_2540 buf, StoryFabricParcel<T> value) {
        parent.encode(value.get(), buf);
    }

    public class_8710.class_9155<class_2540, StoryFabricParcel<T>> getType() {
        return type;
    }

//    public <S extends StoryPacket<S>> void clientHandle(StoryFabricParcel<S> parcel, IPayloadContext ctx) {
//        CogwheelExecutor.schedule(() -> {
//            CogwheelHooks.debugLog(CogwheelEngineNeoForge.PLATFORM_LOG, "Received packet {} from server", parcel);
//            parcel.get().onClientUnsafe(new StoryNeoPacketContext(ctx));
//        });
//    }
//
//    public <S extends StoryPacket<S>> void serverHandle(StoryFabricParcel<S> parcel, IPayloadContext ctx) {
//        CogwheelExecutor.schedule(() -> {
//            CogwheelHooks.debugLog(CogwheelEngineNeoForge.PLATFORM_LOG, "Received packet {} from client: {}", parcel, ctx.player());
//            parcel.get().onServerUnsafe(new StoryNeoPacketContext(ctx));
//        });
//    }

    @Override
    public String toString() {
        return "StoryFabricPacket{" +
                "parent=" + parent +
                ", type=" + type +
                '}';
    }

    public <S extends StoryPacket<S>> void handleClient(StoryFabricParcel<S> parcel, ClientPlayNetworking.Context ctx) {
        CogwheelExecutor.schedule(() -> {
            CogwheelEngineFabric.PLATFORM_LOG.debug("Received packet {} from server", parcel);
            parcel.get().onClientUnsafe(new StoryFabricContext(ctx));
        });
    }

    public <S extends StoryPacket<S>> void handleServer(StoryFabricParcel<S> parcel, ServerPlayNetworking.Context ctx) {
        CogwheelExecutor.schedule(() -> {
            CogwheelEngineFabric.PLATFORM_LOG.debug("Received packet {} from client: {}", parcel, ctx.player());
            parcel.get().onClientUnsafe(new StoryFabricContext(ctx));
        });
    }
}
