/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel;

import com.storyanvil.cogwheel.CogwheelHooks;
import com.storyanvil.cogwheel.config.CogwheelClientConfig;
import com.storyanvil.cogwheel.infrastructure.cog.PropertyHandler;
import com.storyanvil.cogwheel.registry.CogwheelRegistries;
import java.util.HashMap;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CogwheelEngine {
    public static final String MODID = "storyanvil_cogwheel";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"STORYANVIL/COGWHEEL");
    public static final Logger EARLY = LoggerFactory.getLogger((String)"STORYANVIL/COGWHEEL/EARLY-LOGGER");
    public static HashMap<String, PropertyHandler> EARLY_MANAGER = new HashMap();

    public static void init() {
        CogwheelEngine.setupLogInterceptor();
        CogwheelClientConfig.reload();
        CogwheelRegistries.registerDefaultObjects();
    }

    private static void setupLogInterceptor() {
        org.apache.logging.log4j.Logger rootLogger = LogManager.getRootLogger();
        AbstractFilter filter = new AbstractFilter(){
            public static final org.apache.logging.log4j.Logger LOGGER = LogManager.getLogger((String)"STORYANVIL/COGWHEEL/INTERCEPTOR");

            public Filter.Result filter(LogEvent event) {
                if (CogwheelClientConfig.isLoggerIgnored(event.getLoggerName())) {
                    return Filter.Result.DENY;
                }
                if (CogwheelClientConfig.isShowingAllLogs() && !event.getLoggerName().equals("STORYANVIL/COGWHEEL/INTERCEPTOR") && (event.getLevel().equals((Object)Level.DEBUG) || event.getLevel().equals((Object)Level.TRACE) && CogwheelClientConfig.isTraceLogLevelEnabled())) {
                    Object markers = "/";
                    if (event.getMarker() != null) {
                        if (event.getMarker().hasParents()) {
                            StringBuilder m = new StringBuilder();
                            this.markerStep(m, event.getMarker());
                        } else {
                            markers = event.getMarker().getName() + "/";
                        }
                    }
                    if (event.getThrown() == null) {
                        LOGGER.info("{}@{} ({})\n        {}", (Object)event.getLevel(), (Object)event.getLoggerName(), markers, (Object)event.getMessage().getFormattedMessage());
                    } else {
                        LOGGER.info("{}@{} ({})\n        {}", (Object)event.getLevel(), (Object)event.getLoggerName(), markers, (Object)event.getMessage().getFormattedMessage(), (Object)event.getThrown());
                    }
                    return Filter.Result.DENY;
                }
                return Filter.Result.ACCEPT;
            }

            private void markerStep(StringBuilder sb, Marker marker) {
                sb.append(marker.getName()).append('/');
                if (marker.hasParents()) {
                    for (Marker parent : marker.getParents()) {
                        this.markerStep(sb, parent);
                    }
                }
            }
        };
        ((org.apache.logging.log4j.core.Logger)rootLogger).addFilter((Filter)filter);
        CogwheelHooks.startupMessage("CE's Log Interceptor registered!");
    }
}

