/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel;

import com.storyanvil.cogwheel.CogwheelHooks;
import com.storyanvil.cogwheel.EventBus;
import com.storyanvil.cogwheel.api.Api;
import com.storyanvil.cogwheel.config.CogwheelConfig;
import com.storyanvil.cogwheel.infrastructure.env.DefaultEnvironment;
import com.storyanvil.cogwheel.infrastructure.env.LibraryEnvironment;
import com.storyanvil.cogwheel.infrastructure.env.WorldEnvironment;
import com.storyanvil.cogwheel.infrastructure.script.StreamExecutionScript;
import com.storyanvil.cogwheel.util.Bi;
import com.storyanvil.cogwheel.util.StoryUtils;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.minecraft.class_3218;
import net.minecraft.class_638;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CogwheelExecutor {
    @Api.Internal
    @ApiStatus.Internal
    public static final Logger log = LoggerFactory.getLogger((String)"STORYANVIL/COGWHEEL/EXECUTOR");
    private static final ScheduledThreadPoolExecutor poolExecutor = new ScheduledThreadPoolExecutor(2, (ThreadFactory)new DefaultThreadFactory("cogwheel-executor"));
    private static final ScheduledThreadPoolExecutor beltThread = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new DefaultThreadFactory("cogwheel-belt-protocol"));
    private static DefaultEnvironment defaultEnvironment;
    private static HashMap<String, LibraryEnvironment> libraryEnvironments;
    private static WorldEnvironment worldEnvironment;
    private static StreamExecutionScript chatConsole;

    @Api.Internal
    @ApiStatus.Internal
    protected static void init() {
        poolExecutor.setMaximumPoolSize(2);
        beltThread.setMaximumPoolSize(1);
    }

    @Api.Stable(since="2.0.0")
    public static void schedule(Runnable task) {
        poolExecutor.execute(task);
    }

    @Api.Stable(since="2.0.0")
    public static void schedule(Runnable task, int ms) {
        poolExecutor.schedule(task, (long)ms, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api.Stable(since="2.0.0")
    public static void scheduleTickEvent(Consumer<class_3218> task) {
        List<Bi<Consumer<class_3218>, Integer>> list = EventBus.queue;
        synchronized (list) {
            EventBus.queue.add(new Bi<Consumer<class_3218>, Integer>(task, 0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api.Stable(since="2.0.0")
    public static void scheduleTickEvent(Consumer<class_3218> task, int ticks) {
        List<Bi<Consumer<class_3218>, Integer>> list = EventBus.queue;
        synchronized (list) {
            EventBus.queue.add(new Bi<Consumer<class_3218>, Integer>(task, ticks));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api.Stable(since="2.0.0")
    public static void scheduleTickEventClientSide(Consumer<class_638> task) {
        List<Bi<Consumer<class_638>, Integer>> list = EventBus.clientQueue;
        synchronized (list) {
            EventBus.clientQueue.add(new Bi<Consumer<class_638>, Integer>(task, 0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api.Stable(since="2.0.0")
    public static void scheduleTickEventClientSide(Consumer<class_638> task, int ticks) {
        List<Bi<Consumer<class_638>, Integer>> list = EventBus.clientQueue;
        synchronized (list) {
            EventBus.clientQueue.add(new Bi<Consumer<class_638>, Integer>(task, ticks));
        }
    }

    public static void serverStart() {
        log.info("Creating CogScript default environments...");
        defaultEnvironment = new DefaultEnvironment();
        worldEnvironment = new WorldEnvironment();
        if (libraryEnvironments != null) {
            libraryEnvironments.clear();
        }
        libraryEnvironments = new HashMap();
        File libs = new File(CogwheelHooks.getConfigFolder(), "cog-libs/");
        File scripts = new File(CogwheelHooks.getConfigFolder(), "cog/");
        File unpackedLibraries = new File(libs, ".cog");
        if (!libs.exists()) {
            libs.mkdir();
        }
        if (!scripts.exists()) {
            scripts.mkdir();
        }
        if (unpackedLibraries.exists()) {
            StoryUtils.deleteDirectory(unpackedLibraries);
        }
        unpackedLibraries.mkdir();
        CogwheelConfig.reload();
        File[] libFiles = libs.listFiles();
        ArrayList<String> libraryNames = new ArrayList<String>();
        if (libFiles != null) {
            for (File lib : libFiles) {
                String name = lib.getName();
                if (name.endsWith(".salc")) {
                    File unpacked = new File(unpackedLibraries, name);
                    if (!unpacked.mkdir()) {
                        throw new RuntimeException("Failed to create " + String.valueOf(unpacked));
                    }
                    try {
                        StoryUtils.unpackZip(lib, unpacked);
                        libraryNames.add(name);
                        continue;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to unpack " + String.valueOf(lib), e);
                    }
                }
                log.info("File {} is not StoryAnvil Locomotive Car (aka Cogwheel Engine library)", (Object)lib);
            }
        }
        for (String library : libraryNames) {
            LibraryEnvironment environment = new LibraryEnvironment(library);
            libraryEnvironments.put(library, environment);
        }
        log.info("Environments will be notified of initialization");
        defaultEnvironment.dispatchScript("init.sa");
        worldEnvironment.dispatchScript("init.sa");
        for (LibraryEnvironment environment : libraryEnvironments.values()) {
            if (!environment.init(new File(unpackedLibraries, environment.getUniqueIdentifier()))) {
                libraryEnvironments.remove(environment.getUniqueIdentifier());
                environment.dispose();
            }
            environment.dispatchScript("init.sa");
        }
        CogwheelExecutor.createNewConsole();
        switch (CogwheelHooks.performVersionCheck()) {
            case 0: {
                log.info("Update checker failed...");
                break;
            }
            case 1: {
                log.info("Cogwheel Engine is up-to-date");
                break;
            }
            case 2: {
                log.warn("============= [ COGWHEEL ENGINE ] =============");
                log.warn(" Your version of Cogwheel Engine is outdated   ");
                log.warn(" Check modrinth to find new updates.           ");
                log.warn(" https://modrinth.com/mod/cogwheel-engine      ");
                log.warn("============= [ COGWHEEL ENGINE ] =============");
            }
        }
    }

    public static void createNewConsole() {
        log.info("Created new console script");
        chatConsole = new StreamExecutionScript(defaultEnvironment);
        chatConsole.setScriptName("Console-" + UUID.randomUUID().toString().toUpperCase());
    }

    public static StreamExecutionScript getChatConsole() {
        return chatConsole;
    }

    public static void serverStop() {
        log.info("Disposing all CogScript environments...");
        defaultEnvironment.dispose();
        defaultEnvironment = null;
        worldEnvironment.dispose();
        worldEnvironment = null;
        for (LibraryEnvironment environment : libraryEnvironments.values()) {
            environment.dispose();
        }
        libraryEnvironments = null;
    }

    @Api.Stable(since="2.0.0")
    public static DefaultEnvironment getDefaultEnvironment() {
        return defaultEnvironment;
    }

    @Api.Stable(since="2.1.0")
    public static WorldEnvironment getWorldEnvironment() {
        return worldEnvironment;
    }

    @Api.Stable(since="2.0.0")
    public static LibraryEnvironment getLibraryEnvironment(String namespace) {
        return libraryEnvironments.get(namespace);
    }

    @Api.Experimental(since="2.0.0")
    public static Collection<LibraryEnvironment> getLibraryEnvironments() {
        return libraryEnvironments.values();
    }
}

