/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.storyanvil.cogwheel.CogwheelEngine;
import com.storyanvil.cogwheel.CogwheelExecutor;
import com.storyanvil.cogwheel.client.devui.PacketParcel;
import com.storyanvil.cogwheel.config.CogwheelConfig;
import com.storyanvil.cogwheel.data.StoryCodec;
import com.storyanvil.cogwheel.data.StoryPacket;
import com.storyanvil.cogwheel.fabric.CogwheelHooksImpl;
import com.storyanvil.cogwheel.infrastructure.CGPM;
import com.storyanvil.cogwheel.infrastructure.cog.CogPrimalType;
import com.storyanvil.cogwheel.infrastructure.env.CogScriptEnvironment;
import com.storyanvil.cogwheel.infrastructure.testing.TestManagement;
import com.storyanvil.cogwheel.mixinAccess.IStoryEntity;
import com.storyanvil.cogwheel.network.devui.DevConsoleCode;
import com.storyanvil.cogwheel.network.devui.DevDeleteLine;
import com.storyanvil.cogwheel.network.devui.DevEarlySyncPacket;
import com.storyanvil.cogwheel.network.devui.DevEditorLine;
import com.storyanvil.cogwheel.network.devui.DevEditorState;
import com.storyanvil.cogwheel.network.devui.DevEditorUserDelta;
import com.storyanvil.cogwheel.network.devui.DevEnterCallback;
import com.storyanvil.cogwheel.network.devui.DevFlush;
import com.storyanvil.cogwheel.network.devui.DevInsertLine;
import com.storyanvil.cogwheel.network.devui.DevOpenFile;
import com.storyanvil.cogwheel.network.devui.DevOpenViewer;
import com.storyanvil.cogwheel.network.devui.DevResyncRequest;
import com.storyanvil.cogwheel.network.devui.DevRunAndFlush;
import com.storyanvil.cogwheel.network.devui.DevTypeCallback;
import com.storyanvil.cogwheel.network.mc.AnimationBound;
import com.storyanvil.cogwheel.network.mc.AnimationDataBound;
import com.storyanvil.cogwheel.network.mc.CameraForceBound;
import com.storyanvil.cogwheel.network.mc.CameraTransitionBound;
import com.storyanvil.cogwheel.network.mc.DialogBound;
import com.storyanvil.cogwheel.network.mc.DialogChoiceBound;
import com.storyanvil.cogwheel.network.mc.DialogResponseBound;
import com.storyanvil.cogwheel.network.mc.Notification;
import com.storyanvil.cogwheel.util.DefaultCommandOutput;
import com.storyanvil.cogwheel.util.ObjectMonitor;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Date;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2232;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

@ApiStatus.Internal
public class CogwheelHooks {
    private static final Marker debug = MarkerFactory.getMarker((String)"DEBUG");

    @Deprecated
    public static void debugLog(Logger log, String text) {
        log.debug(debug, text);
    }

    @Deprecated
    public static void debugLog(Logger log, String text, Object o) {
        log.debug(debug, text, o);
    }

    @Deprecated
    public static void debugLog(Logger log, String text, Object ... o) {
        log.debug(debug, text, o);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static File getConfigFolder() {
        return CogwheelHooksImpl.getConfigFolder();
    }

    public static void putInt(class_1297 e, String s, int value) {
        ((IStoryEntity)e).storyEntity$putInt(s, value);
    }

    public static void putString(class_1297 e, String s, String value) {
        ((IStoryEntity)e).storyEntity$putString(s, value);
    }

    public static void putBoolean(class_1297 e, String s, boolean value) {
        ((IStoryEntity)e).storyEntity$putBoolean(s, value);
    }

    public static int getInt(class_1297 e, String s, int defaultValue) {
        return ((IStoryEntity)e).storyEntity$getInt(s, defaultValue);
    }

    public static String getString(class_1297 e, String s, String defaultValue) {
        return ((IStoryEntity)e).storyEntity$getString(s, defaultValue);
    }

    public static boolean getBoolean(class_1297 e, String s, boolean defaultValue) {
        return ((IStoryEntity)e).storyEntity$getBoolean(s, defaultValue);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static byte performVersionCheck() {
        return CogwheelHooksImpl.performVersionCheck();
    }

    public static void executeCommand(String command) {
        CogwheelExecutor.scheduleTickEvent(world -> world.method_8503().method_3734().method_44252(new class_2168((class_2165)new DefaultCommandOutput(), new class_243(0.0, 0.0, 0.0), new class_241(0.0f, 0.0f), world, 2, "CogwheelEngine", (class_2561)class_2561.method_43470((String)"CogwheelEngine"), world.method_8503(), null), command));
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static CGPM getLevelData(String key) {
        return CogwheelHooksImpl.getLevelData(key);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void putLevelData(String key, CogPrimalType value) {
        void var1_1;
        CogwheelHooksImpl.putLevelData(key, (CogPrimalType)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void sendPacket(StoryPacket<?> packet, class_3222 plr) {
        void var1_1;
        CogwheelHooksImpl.sendPacket(packet, (class_3222)var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void sendPacketToEveryone(StoryPacket<?> packet) {
        CogwheelHooksImpl.sendPacketToEveryone(packet);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void sendPacketToServer(StoryPacket<?> packet) {
        CogwheelHooksImpl.sendPacketToServer(packet);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void setAnimationData(class_2960[] locations) {
        CogwheelHooksImpl.setAnimationData(locations);
    }

    public static class_3218 getOverworldServer() {
        return class_310.method_1551().method_1576().method_30002();
    }

    public static MinecraftServer getServer() {
        return class_310.method_1551().method_1576();
    }

    public static void serverStart() {
        CogwheelExecutor.serverStart();
    }

    public static void serverStop() {
        CogwheelExecutor.serverStop();
    }

    public static void packetRegistry(PacketRegistrar registrar) {
        registrar.accept("DevConsoleCode", DevConsoleCode.CODEC, DevConsoleCode.class);
        registrar.accept("DevDeleteLine", DevDeleteLine.CODEC, DevDeleteLine.class);
        registrar.accept("DevEarlySyncPacket", DevEarlySyncPacket.CODEC, DevEarlySyncPacket.class);
        registrar.accept("DevEditorLine", DevEditorLine.CODEC, DevEditorLine.class);
        registrar.accept("DevEditorState", DevEditorState.CODEC, DevEditorState.class);
        registrar.accept("DevEditorUserDelta", DevEditorUserDelta.CODEC, DevEditorUserDelta.class);
        registrar.accept("DevEnterCallback", DevEnterCallback.CODEC, DevEnterCallback.class);
        registrar.accept("DevFlush", DevFlush.CODEC, DevFlush.class);
        registrar.accept("DevInsertLine", DevInsertLine.CODEC, DevInsertLine.class);
        registrar.accept("DevOpenFile", DevOpenFile.CODEC, DevOpenFile.class);
        registrar.accept("DevOpenViewer", DevOpenViewer.CODEC, DevOpenViewer.class);
        registrar.accept("DevResyncRequest", DevResyncRequest.CODEC, DevResyncRequest.class);
        registrar.accept("DevRunAndFlush", DevRunAndFlush.CODEC, DevRunAndFlush.class);
        registrar.accept("DevTypeCallback", DevTypeCallback.CODEC, DevTypeCallback.class);
        registrar.accept("AnimationBound", AnimationBound.CODEC, AnimationBound.class);
        registrar.accept("AnimationDataBound", AnimationDataBound.CODEC, AnimationDataBound.class);
        registrar.accept("CameraForceBound", CameraForceBound.CODEC, CameraForceBound.class);
        registrar.accept("CameraTransitionBound", CameraTransitionBound.CODEC, CameraTransitionBound.class);
        registrar.accept("DialogBound", DialogBound.CODEC, DialogBound.class);
        registrar.accept("DialogChoiceBound", DialogChoiceBound.CODEC, DialogChoiceBound.class);
        registrar.accept("DialogResponseBound", DialogResponseBound.CODEC, DialogResponseBound.class);
        registrar.accept("Notification", Notification.CODEC, Notification.class);
        registrar.accept("Parcel", PacketParcel.CODEC, PacketParcel.class);
    }

    public static void commandRegistry(Function<LiteralArgumentBuilder<class_2168>, LiteralCommandNode<class_2168>> register) {
        register.apply((LiteralArgumentBuilder<class_2168>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"@storyconsole").requires(css -> css.method_9259(1))).then(class_2170.method_9244((String)"cmd", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            String text = StringArgumentType.getString((CommandContext)ctx, (String)"cmd");
            if (text.equals(":reset")) {
                CogwheelExecutor.createNewConsole();
            } else {
                CogwheelExecutor.getChatConsole().addLineRedirecting(text);
            }
            return 1;
        }))));
        register.apply((LiteralArgumentBuilder<class_2168>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"@storyanvil").requires(css -> css.method_9259(1))).then(class_2170.method_9247((String)"dispatch-script").then(class_2170.method_9244((String)"name", (ArgumentType)class_2232.method_9441()).executes(ctx -> {
            String name = class_2232.method_9443((CommandContext)ctx, (String)"name").toString();
            if (CogwheelConfig.isDisablingAllScripts() && !name.contains("config-main.json")) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Script execution is disabled from configs!").method_27692(class_124.field_1061));
                return 0;
            }
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Script execution will be dispatched"), true);
            try {
                CogScriptEnvironment.dispatchScriptGlobal(name);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return 0;
        })))).then(class_2170.method_9247((String)"dump").executes(ctx -> {
            StringBuilder sb = new StringBuilder("=== === === === === COGWHEEL ENGINE REPORT === === === === ===\n");
            sb.append("DATE: ").append(new Date());
            ObjectMonitor.dumpAll(sb);
            CogwheelEngine.LOGGER.warn("\n{}", (Object)sb);
            return 0;
        }))).then(class_2170.method_9247((String)"run-tests").executes(ctx -> {
            TestManagement.startTesting(true);
            return 0;
        }))).then(class_2170.method_9247((String)"run-all-tests").executes(ctx -> {
            TestManagement.startTesting(false);
            return 0;
        }))));
        register.apply((LiteralArgumentBuilder<class_2168>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"@storyclient").requires(css -> css.method_9259(0))).then(class_2170.method_9247((String)"dialog").then(class_2170.method_9244((String)"answer", (ArgumentType)IntegerArgumentType.integer()).then(class_2170.method_9244((String)"dialog", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            String dialogID = StringArgumentType.getString((CommandContext)ctx, (String)"dialog");
            if (!CogwheelExecutor.getDefaultEnvironment().getDialogs().containsKey(dialogID)) {
                return 1;
            }
            Consumer<Integer> call = CogwheelExecutor.getDefaultEnvironment().getDialogs().get(dialogID);
            CogwheelExecutor.getDefaultEnvironment().getDialogs().remove(dialogID);
            call.accept(IntegerArgumentType.getInteger((CommandContext)ctx, (String)"answer"));
            return 0;
        }))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"dev-resync").requires(class_2168::method_43737)).executes(ctx -> {
            DevEarlySyncPacket.syncFor(((class_2168)ctx.getSource()).method_44023(), false);
            return 0;
        }))));
    }

    public static JsonObject readJarResource(String path) throws IOException {
        try (InputStream in = CogwheelEngine.class.getResourceAsStream("cgwhl/" + path);){
            if (in == null) {
                throw new IOException("Failed to get input stream for in-jar json resource: cgwhl/" + path);
            }
            try {
                JsonElement e = JsonParser.parseReader((Reader)new InputStreamReader(in));
                JsonObject jsonObject = e.getAsJsonObject();
                return jsonObject;
            }
            catch (JsonParseException | IllegalStateException ee) {
                throw new IOException("in-jar json resource: cgwhl/" + path + " is not JSON object");
            }
        }
    }

    @ExpectPlatform
    @Contract(value="-> !null")
    @ExpectPlatform.Transformed
    public static class_304 getDevUIBind() {
        return CogwheelHooksImpl.getDevUIBind();
    }

    @ExpectPlatform
    @Contract(value="-> !null")
    @ExpectPlatform.Transformed
    public static class_1792 getInspectorItem() {
        return CogwheelHooksImpl.getInspectorItem();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void startupMessage(String message) {
        CogwheelHooksImpl.startupMessage(message);
    }

    public static interface PacketRegistrar {
        public <T extends StoryPacket<T>> void accept(String var1, StoryCodec<T> var2, Class<T> var3);
    }
}

