/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.client.devui;

import com.storyanvil.cogwheel.CogwheelExecutor;
import com.storyanvil.cogwheel.client.devui.DWCodeEditor;
import com.storyanvil.cogwheel.client.devui.DWTabbedView;
import com.storyanvil.cogwheel.util.Bi;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class DWCodeViewer
extends DWTabbedView.Tab {
    private String name;
    private ArrayList<Bi<String, class_5250>> code = new ArrayList();
    private int scroll = 0;
    private int scrollHor = 0;
    private boolean shift = false;
    private int codeLeft = 0;
    private DWCodeEditor.Highlighter highlighter;
    private static final class_5250 EMPTY = class_2561.method_43470((String)"UNHIGHLIGHTED").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067});
    private static final class_5250 FAILURE = class_2561.method_43470((String)"HIGHLIGHTER FAILURE").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067});

    public DWCodeViewer(String name) {
        this.name = name;
        this.highlighter = DWCodeEditor.getHighlighterByFileName(name);
    }

    @Override
    public void renderS(@NotNull class_332 g, int mouseX, int mouseY, float partialTick, boolean isHovered, float timeHovered, int top, int left, int right, int bottom) {
        int y = top;
        g.method_44379(left, top, right, bottom);
        int codeLeftt = this.codeLeft - this.scrollHor;
        for (int i = this.scroll; i < this.code.size(); ++i) {
            class_5250 b = this.code.get(i).getB();
            this.draw(g, codeLeftt, y, (class_2561)(b == null ? EMPTY : b), this.ui().font);
            Objects.requireNonNull(this.ui().font);
            y += 9;
        }
        g.method_44380();
    }

    public boolean method_25404(int pKeyCode, int pScanCode, int pModifiers) {
        this.shift = (pModifiers & 1) == 1;
        return false;
    }

    public boolean method_16803(int pKeyCode, int pScanCode, int pModifiers) {
        this.shift = (pModifiers & 1) == 1;
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (verticalAmount != 0.0) {
            this.scroll = class_3532.method_15340((int)(this.scroll + (verticalAmount > 0.0 ? -1 : 1)), (int)0, (int)(this.code.size() - 1));
        }
        if (horizontalAmount != 0.0) {
            this.scrollHor = Math.max(this.scrollHor + (horizontalAmount > 0.0 ? -4 : 4), 0);
        }
        return true;
    }

    @Override
    public void resize(@NotNull class_310 minecraft, int width, int height) {
        super.resize(minecraft, width, height);
        this.codeLeft = this.getLeft() + 5;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public synchronized void setCode(String code) {
        int i;
        this.code.clear();
        String[] lines = code.split("\n");
        for (i = 0; i < lines.length; ++i) {
            this.code.add(new Bi<String, class_5250>(lines[i], EMPTY));
        }
        for (i = 0; i < lines.length; ++i) {
            this.highlight(i);
        }
    }

    public synchronized void highlight(int line) {
        try {
            class_5250 c = this.highlighter.highlight(line, this.code, this.code.get(line).getA());
            this.code.get(line).setB(c);
        }
        catch (Exception e) {
            CogwheelExecutor.log.error("Trying to highlight line \"{}\" with {}", new Object[]{this.code.get(line).getA(), this.highlighter.getClass().getCanonicalName(), e});
            this.code.get(line).setB(FAILURE);
        }
    }
}

