/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.client.devui;

import com.storyanvil.cogwheel.client.devui.DWCodeEditor;
import com.storyanvil.cogwheel.client.devui.DWConsoleChoice;
import com.storyanvil.cogwheel.client.devui.DWTabbedView;
import com.storyanvil.cogwheel.client.devui.DevUI;
import com.storyanvil.cogwheel.network.devui.CogwheelNetwork;
import com.storyanvil.cogwheel.network.devui.DevConsoleCode;
import com.storyanvil.cogwheel.network.devui.DevEarlySyncPacket;
import com.storyanvil.cogwheel.network.devui.DevOpenFile;
import com.storyanvil.cogwheel.network.devui.DevResyncRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.Contract;

public class DWConsoleAutoComplete {
    private static final List<DWConsoleChoice> emptyImmutable = List.of();
    private static List<DWConsoleChoice> fullChoicePool = null;
    private static List<DWConsoleChoice> eraseChoicePool;
    private static List<DWConsoleChoice> nextChoicePool;
    private static String old;

    public static void init() {
        if (fullChoicePool != null) {
            return;
        }
        fullChoicePool = new ArrayList<DWConsoleChoice>();
        eraseChoicePool = emptyImmutable;
        nextChoicePool = fullChoicePool;
        old = "";
        DWConsoleAutoComplete.register("!", "<code>", "Executes CogScript code", Actions::cogScript);
        DWConsoleAutoComplete.register("O", "<env>:<file name>", "Opens file", Actions::openFile);
        DWConsoleAutoComplete.register("open", "<env>:<file name>", "Opens file", Actions::openFile);
        DWConsoleAutoComplete.register("dispatch", "<env>:<file name>", "Dispatches file", Actions::dispatchFile);
        DWConsoleAutoComplete.register("fullscreen", "Toggle fullscreen mode", Actions::fullscreen);
        DWConsoleAutoComplete.register("resync", "DevUI Resync", Actions::resync);
        DWConsoleAutoComplete.register("inspector", "Gives inspector tool", Actions::inspector);
        DWConsoleAutoComplete.register("save", "Saves currently open file", Actions::save);
        DWConsoleAutoComplete.register("run", "Executes currently open file", Actions::run);
        DWConsoleAutoComplete.register("gmc", "Sets gamemode to creative", Actions::creative);
        DWConsoleAutoComplete.register("gms", "Sets gamemode to survival", Actions::survival);
        DWConsoleAutoComplete.register("gma", "Sets gamemode to adventure", Actions::adventure);
        DWConsoleAutoComplete.register("closeall", "Closes all tabs", Actions::closeall);
    }

    public static void register(String mask, String args, String desc, Consumer<String> executor) {
        fullChoicePool.add(new DWConsoleChoice(mask, args, desc, executor));
    }

    public static void register(String mask, String desc, Consumer<String> executor) {
        fullChoicePool.add(new DWConsoleChoice(mask, desc, executor));
    }

    public static void empty() {
        eraseChoicePool = emptyImmutable;
        nextChoicePool = fullChoicePool;
        old = "";
        if (DevUI.instance != null && DevUI.instance.console != null && DevUI.instance.console.editBox != null && !DevUI.instance.console.editBox.method_44405().isEmpty()) {
            DevUI.instance.console.editBox.method_44400("");
        }
        DWConsoleAutoComplete.rerenderChoices(old);
    }

    public static void execute(String value) {
        if (nextChoicePool.size() == 1) {
            DWConsoleChoice choice = nextChoicePool.get(0);
            if (!value.startsWith(choice.getMask())) {
                return;
            }
            int l = choice.getMask().length();
            choice.getExecutor().accept(value.substring(l > choice.getMask().length() ? l + 1 : l));
            DWConsoleAutoComplete.empty();
            DevUI.instance.drawConsole = false;
        }
    }

    public static void update(String value) {
        if (value.length() > 256) {
            value = value.substring(0, 256);
            DevUI.instance.console.editBox.method_44400(value);
            return;
        }
        DWConsoleAutoComplete.setEditable(false);
        int space = value.indexOf(32);
        value = value.substring(0, space == -1 ? value.length() : space);
        if (value.isEmpty()) {
            DWConsoleAutoComplete.empty();
            return;
        }
        int oldSize = old.length();
        int size = value.length();
        if (size - oldSize == 1 && value.startsWith(old)) {
            char added = value.charAt(size - 1);
            int checkIndex = size - 1;
            ArrayList<DWConsoleChoice> applicable = new ArrayList<DWConsoleChoice>();
            for (DWConsoleChoice choice : nextChoicePool) {
                if (choice.getMask().length() < size || choice.getMask().charAt(checkIndex) != added) continue;
                applicable.add(choice);
            }
            eraseChoicePool = nextChoicePool;
            nextChoicePool = applicable;
        } else if (size < oldSize && oldSize - size == 1 && old.startsWith(value)) {
            char removed = old.charAt(size - 1);
            String checkFor = value.substring(0, value.length() - 1);
            ArrayList<DWConsoleChoice> applicable = new ArrayList<DWConsoleChoice>();
            for (DWConsoleChoice choice : fullChoicePool) {
                if (!choice.getMask().startsWith(checkFor)) continue;
                applicable.add(choice);
            }
            nextChoicePool = eraseChoicePool;
            eraseChoicePool = applicable;
        } else {
            DWConsoleAutoComplete.recompute(value);
        }
        DWConsoleAutoComplete.rerenderChoices(value);
        old = value;
    }

    private static void setEditable(boolean pEnabled) {
        if (DevUI.instance == null || DevUI.instance.console == null) {
            return;
        }
        DevUI.instance.console.setEditable(pEnabled);
    }

    private static void recompute(String value) {
        ArrayList<DWConsoleChoice> nextApplicable = new ArrayList<DWConsoleChoice>();
        ArrayList<DWConsoleChoice> eraseApplicable = new ArrayList<DWConsoleChoice>();
        String eraseMask = value.substring(0, value.length() - 1);
        int checkPos = value.length() - 1;
        char check = value.charAt(checkPos);
        for (DWConsoleChoice choice : fullChoicePool) {
            if (!choice.getMask().startsWith(eraseMask)) continue;
            eraseApplicable.add(choice);
            if (choice.getMask().length() <= checkPos || choice.getMask().charAt(checkPos) != check) continue;
            nextApplicable.add(choice);
        }
        nextChoicePool = nextApplicable;
        eraseChoicePool = eraseApplicable;
    }

    private static void rerenderChoices(String q) {
        if (DevUI.instance.console == null) {
            return;
        }
        List<class_2561> renders = DevUI.instance.console.getTips();
        renders.clear();
        if (nextChoicePool.isEmpty()) {
            renders.add((class_2561)class_2561.method_43470((String)" \u26a0 No results for this query!").method_27692(class_124.field_1061));
        } else {
            int start = q.length();
            int limit = 10;
            for (DWConsoleChoice choice : nextChoicePool) {
                if (--limit == 0) {
                    renders.add((class_2561)class_2561.method_43470((String)("... and other " + (nextChoicePool.size() - 9) + " results")).method_27692(class_124.field_1080));
                    break;
                }
                renders.add((class_2561)class_2561.method_43470((String)q).method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)choice.getMask().substring(Math.min(start, choice.getMask().length()))).method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)choice.getArguments()).method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)choice.getDescription()).method_27692(class_124.field_1068)));
            }
        }
        DWConsoleAutoComplete.setEditable(true);
    }

    public static class Actions {
        @Contract(pure=true)
        private static DevUI ui() {
            return DevUI.instance;
        }

        public static void fullscreen(String s) {
            Actions.ui().fullscreen = !Actions.ui().fullscreen;
            Actions.ui().scheduleResize();
        }

        public static void resync(String s) {
            CogwheelNetwork.sendToServer(new DevEarlySyncPacket(true, false));
            CogwheelNetwork.sendToServer(new DevResyncRequest());
        }

        public static void inspector(String s) {
            CogwheelNetwork.sendToServer(new DevConsoleCode("Cogwheel.executeCommand(\"give " + class_310.method_1551().field_1724.method_5820() + " storyanvil_cogwheel:inspector\")"));
        }

        public static void cogScript(String s) {
            CogwheelNetwork.sendToServer(new DevConsoleCode(s));
        }

        public static void openFile(String s) {
            CogwheelNetwork.sendToServer(new DevOpenFile(class_2960.method_12829((String)s.trim())));
        }

        public static void save(String s) {
            DWTabbedView.Tab tab = Actions.ui().tabs.selected;
            if (tab instanceof DWCodeEditor) {
                DWCodeEditor editor = (DWCodeEditor)tab;
                editor.save();
            }
        }

        public static void run(String s) {
            DWTabbedView.Tab tab = Actions.ui().tabs.selected;
            if (tab instanceof DWCodeEditor) {
                DWCodeEditor editor = (DWCodeEditor)tab;
                editor.run();
            }
        }

        public static void creative(String s) {
            CogwheelNetwork.sendToServer(new DevConsoleCode("Cogwheel.executeCommand(\"gamemode creative " + class_310.method_1551().field_1724.method_5820() + "\")"));
        }

        public static void survival(String s) {
            CogwheelNetwork.sendToServer(new DevConsoleCode("Cogwheel.executeCommand(\"gamemode survival " + class_310.method_1551().field_1724.method_5820() + "\")"));
        }

        public static void adventure(String s) {
            CogwheelNetwork.sendToServer(new DevConsoleCode("Cogwheel.executeCommand(\"gamemode adventure " + class_310.method_1551().field_1724.method_5820() + "\")"));
        }

        public static void closeall(String s) {
            Actions.ui().tabs.closeAll();
        }

        public static void dispatchFile(String s) {
            CogwheelNetwork.sendToServer(new DevConsoleCode("Cogwheel.executeCommand(\"@storyanvil dispatch-script " + s.trim() + "\")"));
        }
    }
}

