/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.client.devui;

import com.storyanvil.cogwheel.client.devui.DWCodeEditor;
import com.storyanvil.cogwheel.util.Bi;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;

public class DevHighlighters {

    public static class JSON
    extends DWCodeEditor.Highlighter {
        @Override
        public class_5250 highlight(int lineNumber, ArrayList<Bi<String, class_5250>> code, String line) {
            ColorHelper helper = new ColorHelper(line);
            int prv = 32;
            for (int i = 0; i < line.length(); ++i) {
                char c = line.charAt(i);
                if (c == '\"' && prv != 92) {
                    char c2;
                    int ii;
                    int prv2 = 32;
                    for (ii = i + 1; ii < line.length() && ((c2 = line.charAt(ii)) != '\"' || prv2 == 92); ++ii) {
                        prv2 = c2;
                    }
                    helper.color(i, ++ii, CodeColor.STRING);
                    i = ii;
                    prv = c;
                    continue;
                }
                if (Character.isDigit(c)) {
                    helper.colorSingle(i, CodeColor.NUMBER);
                } else if (c == 'l' && line.substring(i - 4, i + 1).equals(" null")) {
                    helper.color(i - 4, i + 1, CodeColor.KEYWORD);
                }
                prv = c;
            }
            return helper.compile();
        }
    }

    public static class CogScript
    extends DWCodeEditor.Highlighter {
        @Override
        public class_5250 highlight(int lineNumber, ArrayList<Bi<String, class_5250>> code, String line) {
            ColorHelper helper = new ColorHelper(line);
            CogScript.process(helper, 0, line.length(), line);
            return helper.compile();
        }

        public static void process(ColorHelper helper, int from, int to, String fullLine) {
            String sub = fullLine.substring(from, to);
        }
    }

    public static class StoryAnvilDialog
    extends DWCodeEditor.Highlighter {
        @Override
        public class_5250 highlight(int lineNumber, ArrayList<Bi<String, class_5250>> code, String line) {
            int offset;
            ColorHelper helper = new ColorHelper(line);
            if (line.isBlank()) {
                return helper.compile();
            }
            for (offset = 0; offset < line.length() - 1 && line.charAt(offset) == ' '; ++offset) {
            }
            char c = line.charAt(offset);
            if (c == '!') {
                CogScript.process(helper, offset + 1, line.length(), line);
            } else if (c == '#') {
                helper.color(offset, line.length(), CodeColor.COMMENT);
            } else if (c == '@') {
                char sepC;
                int sep = offset;
                int bound = line.length() - 1;
                while (sep < bound && (sepC = line.charAt(++sep)) != ':' && sepC != '?' && sepC != '!') {
                }
                helper.color(offset, sep, CodeColor.VARIABLE);
                helper.color(sep, sep + 1, CodeColor.KEYWORD);
            } else if (c == '+') {
                helper.color(offset, offset + 1, CodeColor.SPECIAL);
            } else if (c != '/') {
                helper.color(offset, line.length(), CodeColor.ERROR);
            }
            return helper.compile();
        }
    }

    public static class Empty
    extends DWCodeEditor.Highlighter {
        @Override
        public class_5250 highlight(int lineNumber, ArrayList<Bi<String, class_5250>> code, String line) {
            return class_2561.method_43470((String)line);
        }
    }

    public static interface ColorSup
    extends Supplier<Integer>,
    UnaryOperator<class_2583> {
        @Override
        default public class_2583 apply(class_2583 style) {
            return style;
        }
    }

    public static enum CodeColor implements ColorSup
    {
        WHITE(class_124.field_1068.method_532()),
        STRING(class_124.field_1077.method_532()),
        COMMENT(class_124.field_1063.method_532()),
        ERROR(class_124.field_1061.method_532()){

            @Override
            public class_2583 apply(class_2583 style) {
                return style.method_36140(Boolean.valueOf(true));
            }
        }
        ,
        VARIABLE(class_124.field_1078.method_532()){

            @Override
            public class_2583 apply(class_2583 style) {
                return style.method_30938(Boolean.valueOf(true));
            }
        }
        ,
        KEYWORD(class_124.field_1065.method_532()),
        SPECIAL(class_124.field_1075.method_532()),
        NUMBER(class_124.field_1062.method_532());

        public final int color;

        private CodeColor(int color) {
            this.color = color;
        }

        @Override
        public Integer get() {
            return this.color;
        }
    }

    public static class ColorHelper {
        private String line;
        private ColorSup[] colors;

        public ColorHelper(String line) {
            this.line = line;
            this.colors = new ColorSup[line.length()];
            Arrays.fill(this.colors, CodeColor.WHITE);
        }

        public void color(int from, int to, ColorSup color) {
            for (int i = from; i < to && i < this.colors.length; ++i) {
                this.colors[i] = color;
            }
        }

        public void colorSingle(int i, ColorSup colorSup) {
            this.colors[i] = colorSup;
        }

        public class_5250 compile() {
            class_5250 cp = class_2561.method_43473().method_27692(class_124.field_1070);
            Integer color = null;
            ColorSup sup = null;
            int from = 0;
            for (int i = 0; i < this.colors.length; ++i) {
                int c = (Integer)this.colors[i].get();
                if (color == null) {
                    color = c;
                    sup = this.colors[i];
                    from = i;
                    continue;
                }
                if (color == c) continue;
                class_5250 n = class_2561.method_43470((String)this.line.substring(from, i));
                Integer finalColor = color;
                ColorSup finalSup = sup;
                n.method_27696(finalSup.apply(class_2583.field_24360).method_36139(finalColor.intValue()));
                cp.method_10852((class_2561)class_2561.method_43473().method_27692(class_124.field_1070)).method_10852((class_2561)n);
                color = c;
                from = i;
                sup = this.colors[i];
            }
            class_5250 n = class_2561.method_43470((String)this.line.substring(from));
            if (sup != null) {
                n.method_27696(sup.apply(class_2583.field_24360).method_36139(color.intValue()));
            }
            cp.method_10852((class_2561)class_2561.method_43473().method_27692(class_124.field_1070)).method_10852((class_2561)n);
            return cp;
        }
    }
}

