/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.client.devui;

import com.storyanvil.cogwheel.client.devui.DWButton;
import com.storyanvil.cogwheel.client.devui.DWCodeEditor;
import com.storyanvil.cogwheel.client.devui.DWCodeViewer;
import com.storyanvil.cogwheel.client.devui.DWConsole;
import com.storyanvil.cogwheel.client.devui.DWConsoleAutoComplete;
import com.storyanvil.cogwheel.client.devui.DWTabbedView;
import com.storyanvil.cogwheel.client.devui.DevWidget;
import com.storyanvil.cogwheel.client.devui.QuestUIScreen;
import com.storyanvil.cogwheel.network.devui.CogwheelNetwork;
import com.storyanvil.cogwheel.network.devui.DevEarlySyncPacket;
import com.storyanvil.cogwheel.network.devui.DevResyncRequest;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class DevUI
implements class_364 {
    public static final class_2960 ATLAS = class_2960.method_60655((String)"storyanvil_cogwheel", (String)"textures/gui/devui.png");
    public static final int ATLAS_SIZE = 256;
    protected static DevUI instance;
    public static boolean permitted;
    protected DevWidget hovered = null;
    protected float hoverTime = 0.0f;
    private ArrayList<DevWidget> widgets = new ArrayList();
    protected int screenWidth = 0;
    protected int screenHeight = 0;
    protected class_327 font;
    boolean fullscreen = false;
    protected int panelLeft = 0;
    protected int panelTop = 0;
    protected boolean drawConsole = false;
    DWConsole console;
    DWTabbedView tabs;

    public DevUI(int w, int h) {
        instance = this;
        this.screenWidth = w;
        this.screenHeight = h;
        this.font = class_310.method_1551().field_1772;
        this.addWidget(new DWButton(0, 0, 11, 11, 0, 0, 11, 11, (class_2561)class_2561.method_43471((String)"ui.storyanvil_cogwheel.devui.fullscreen")){

            @Override
            public void press(int btn) {
                if (btn == 0) {
                    DevUI.this.fullscreen = !DevUI.this.fullscreen;
                    DevUI.this.scheduleResize();
                }
            }
        });
        this.addWidget(new DWButton(this, 11, 0, 11, 11, 10, 0, 11, 11, (class_2561)class_2561.method_43471((String)"ui.storyanvil_cogwheel.devui.resync")){

            @Override
            public void press(int btn) {
                if (btn == 0) {
                    CogwheelNetwork.sendToServer(new DevEarlySyncPacket(permitted, false));
                    CogwheelNetwork.sendToServer(new DevResyncRequest());
                }
            }
        });
        this.addWidget(new DWButton(this, 22, 0, 11, 11, 20, 0, 11, 11, (class_2561)class_2561.method_43471((String)"ui.storyanvil_cogwheel.devui.console")){

            @Override
            public void press(int btn) {
                if (btn == 0) {
                    instance.openConsole();
                }
            }
        });
        this.addWidget(new DWButton(this, 33, 0, 11, 11, 30, 0, 11, 11, (class_2561)class_2561.method_43471((String)"ui.storyanvil_cogwheel.devui.run")){

            @Override
            public void press(int btn) {
                DWTabbedView.Tab s;
                if (btn == 0 && (s = DevUI.instance.tabs.selected) instanceof DWCodeEditor) {
                    DWCodeEditor editor = (DWCodeEditor)s;
                    editor.run();
                }
            }
        });
        this.addWidget(new DWButton(this, 44, 0, 11, 11, 40, 0, 11, 11, (class_2561)class_2561.method_43471((String)"ui.storyanvil_cogwheel.devui.save")){

            @Override
            public void press(int btn) {
                DWTabbedView.Tab s;
                if (btn == 0 && (s = DevUI.instance.tabs.selected) instanceof DWCodeEditor) {
                    DWCodeEditor editor = (DWCodeEditor)s;
                    editor.save();
                }
            }
        });
        this.addWidget(new DWButton(this, 55, 0, 11, 11, 60, 0, 11, 11, (class_2561)class_2561.method_43471((String)"ui.storyanvil_cogwheel.devui.quests")){

            @Override
            public void press(int btn) {
                if (btn == 0) {
                    class_310.method_1551().method_1507((class_437)new QuestUIScreen());
                }
            }
        });
        this.tabs = this.addWidget(new DWTabbedView(0, 12, 0, 0){

            @Override
            public void resize(@NotNull class_310 minecraft, int width, int height) {
                this.setWidth(this.ui().screenWidth - this.ui().panelLeft);
                this.setHeight(DevUI.this.screenHeight - this.getRawTop());
                super.resize(minecraft, width, height);
            }
        });
        this.console = this.addWidget(new DWConsole());
        DWConsoleAutoComplete.update(this.console.editBox.method_44405());
        this.scheduleResize();
    }

    public static DevUI getInstance() {
        return instance;
    }

    public void openConsole() {
        this.drawConsole = true;
    }

    public void init() {
        this.hovered = null;
    }

    public void renderLogic(@NotNull class_332 g, int mouseX, int mouseY, float partialTick, int width, int height) {
        DevWidget widget;
        int i;
        if (this.screenWidth != width || this.screenHeight != height) {
            this.resizeLogic(class_310.method_1551(), width, height);
        }
        g.method_25294(this.panelLeft, this.panelTop, this.screenWidth, this.screenHeight, -15461087);
        DevWidget oldHovered = this.hovered;
        boolean allowHover = true;
        this.hovered = null;
        if (this.drawConsole) {
            this.hovered = this.console;
            allowHover = false;
        }
        for (i = 0; i < this.widgets.size(); ++i) {
            boolean hover;
            widget = this.widgets.get(i);
            boolean bl = hover = allowHover && widget.isHovered(mouseX, mouseY);
            if (hover) {
                this.hovered = widget;
                this.hoverTime = this.hovered != oldHovered ? 0.0f : (this.hoverTime += partialTick);
            }
            widget.render(g, mouseX, mouseY, partialTick, hover, this.hoverTime);
        }
        for (i = 0; i < this.widgets.size(); ++i) {
            widget.renderLast(g, mouseX, mouseY, partialTick, this.hovered == (widget = this.widgets.get(i)), this.hoverTime);
        }
    }

    public void resizeLogic(@NotNull class_310 minecraft, int width, int height) {
        this.screenWidth = width;
        this.screenHeight = height;
        this.panelTop = 0;
        this.panelLeft = this.fullscreen ? 0 : this.screenWidth / 2;
        for (int i = 0; i < this.widgets.size(); ++i) {
            DevWidget widget = this.widgets.get(i);
            widget.resize(minecraft, width, height);
        }
    }

    public boolean method_25404(int key, int scancode, int mods) {
        if (this.drawConsole) {
            return this.console.method_25404(key, scancode, mods);
        }
        return this.tabs.selected != null && this.tabs.selected.method_25404(key, scancode, mods);
    }

    public void method_25365(boolean pFocused) {
    }

    public boolean method_25370() {
        return true;
    }

    public boolean method_25402(double pMouseX, double pMouseY, int button) {
        return this.hovered != null && this.hovered.method_25402(pMouseX, pMouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        return this.hovered != null && this.hovered.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public <T extends DevWidget> T addWidget(T widget) {
        this.widgets.add(widget);
        this.scheduleResize();
        return widget;
    }

    public void scheduleResize() {
        this.screenHeight = -1;
    }

    public boolean method_16803(int key, int scancode, int mods) {
        if (this.hovered != null && this.hovered.method_16803(key, scancode, mods)) {
            return true;
        }
        return this.tabs.selected != null && this.tabs.selected.method_16803(key, scancode, mods);
    }

    public boolean method_25400(char pCodePoint, int pModifiers) {
        if (this.hovered != null && this.hovered.method_25400(pCodePoint, pModifiers)) {
            return true;
        }
        return this.tabs.selected != null && this.tabs.selected.method_25400(pCodePoint, pModifiers);
    }

    public void method_16014(double pMouseX, double pMouseY) {
        if (this.hovered != null) {
            this.hovered.method_16014(pMouseX, pMouseY);
        }
    }

    public boolean method_25406(double pMouseX, double pMouseY, int pButton) {
        return this.hovered != null && this.hovered.method_25406(pMouseX, pMouseY, pButton);
    }

    public boolean method_25403(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        return this.hovered != null && this.hovered.method_25403(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public void addTab(DWCodeViewer viewer) {
        this.tabs.openAndSelect(viewer);
    }

    static {
        permitted = false;
    }
}

