/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.client.devui;

import com.storyanvil.cogwheel.CogwheelEngine;
import com.storyanvil.cogwheel.CogwheelHooks;
import com.storyanvil.cogwheel.data.IStoryPacketContext;
import com.storyanvil.cogwheel.data.StoryCodec;
import com.storyanvil.cogwheel.data.StoryCodecs;
import com.storyanvil.cogwheel.data.StoryPacket;
import java.lang.reflect.AccessFlag;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2540;

public class PacketParcel
implements StoryPacket<PacketParcel> {
    private final ArrayList<StoryPacket<?>> packets;
    public static final StoryCodec<PacketParcel> CODEC = new StoryCodec<PacketParcel>((parcel, buf) -> {
        buf.method_53002(parcel.packets.size());
        for (StoryPacket<?> packet : parcel.packets) {
            StoryCodecs.STRING.encode(packet.getClass().getCanonicalName(), (class_2540)buf);
            PacketParcel.getCodec(packet.getClass()).encode(packet, (class_2540)buf);
        }
    }, buf -> {
        int size = buf.readInt();
        ArrayList packets = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            String clazz = StoryCodecs.STRING.decode((class_2540)buf);
            packets.add(PacketParcel.getCodec(clazz).decode((class_2540)buf));
        }
        return new PacketParcel(packets);
    });

    private static StoryCodec<StoryPacket<?>> getCodec(String clazz) {
        try {
            return PacketParcel.getCodec(Class.forName(clazz));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Failed to find class to find Codec for parcel", e);
        }
    }

    private static StoryCodec<StoryPacket<?>> getCodec(Class<?> clazz) {
        try {
            Field field = clazz.getField("CODEC");
            if (!field.accessFlags().contains((Object)AccessFlag.STATIC)) {
                throw new NoSuchFieldException("No public static CODEC in class: " + String.valueOf(clazz));
            }
            if (!field.accessFlags().contains((Object)AccessFlag.PUBLIC)) {
                throw new NoSuchFieldException("No public static CODEC in class: " + String.valueOf(clazz));
            }
            return (StoryCodec)field.get(null);
        }
        catch (ClassCastException | IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Failed to get Codec for parcel!", e);
        }
    }

    private PacketParcel(ArrayList<StoryPacket<?>> packets) {
        this.packets = packets;
        for (int i = 0; i < this.packets.size(); ++i) {
            if (this.packets.get(i) != null) continue;
            this.packets.remove(--i);
        }
    }

    private PacketParcel() {
        this.packets = new ArrayList();
    }

    @Override
    public StoryCodec<PacketParcel> getStoryCodec() {
        return CODEC;
    }

    @Override
    public void onServerUnsafe(IStoryPacketContext ctx) {
        for (StoryPacket<?> packet : this.packets) {
            CogwheelHooks.debugLog(CogwheelEngine.LOGGER, "Handling server parcel {}", (Object)this);
            packet.onServerUnsafe(ctx);
        }
    }

    @Override
    public void onClientUnsafe(IStoryPacketContext ctx) {
        for (StoryPacket<?> packet : this.packets) {
            CogwheelHooks.debugLog(CogwheelEngine.LOGGER, "Handling client parcel {}", (Object)this);
            packet.onClientUnsafe(ctx);
        }
    }

    public static PacketParcel of(StoryPacket<?> ... packets) {
        return new PacketParcel(new ArrayList(List.of(packets)));
    }

    public static PacketParcel of(ArrayList<StoryPacket<?>> packets) {
        return new PacketParcel(packets);
    }

    public static PacketParcel of(List<StoryPacket<?>> packets) {
        return new PacketParcel(new ArrayList(packets));
    }

    public String toString() {
        return "PacketParcel{" + String.valueOf(this.packets) + "}";
    }
}

