/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import com.storyanvil.cogwheel.CogwheelExecutor;
import com.storyanvil.cogwheel.CogwheelHooks;
import com.storyanvil.cogwheel.api.Api;
import com.storyanvil.cogwheel.network.devui.DevEarlySyncPacket;
import com.storyanvil.cogwheel.registry.CogwheelRegistries;
import com.storyanvil.cogwheel.util.Bi;
import com.storyanvil.cogwheel.util.ScriptLineHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class CogwheelConfig {
    private static JsonObject json = null;
    private static boolean disableAllScripts = false;
    private static boolean disableBelt = false;
    private static boolean npcTalkingAnimation = true;
    private static boolean monitorEnabled = false;
    private static boolean devEnvironment = true;

    private static boolean getBool(String name, boolean defauld) {
        JsonElement e = json.get(name);
        if (e == null || !e.isJsonPrimitive()) {
            json.addProperty(name, Boolean.valueOf(defauld));
            return defauld;
        }
        try {
            return e.getAsBoolean();
        }
        catch (IllegalStateException | UnsupportedOperationException ignored) {
            json.addProperty(name, Boolean.valueOf(defauld));
            return defauld;
        }
    }

    private static List<String> getStringArray(String name, List<String> defauld) {
        JsonElement e = json.get(name);
        if (e == null || !e.isJsonArray()) {
            JsonArray a = new JsonArray();
            for (String s : defauld) {
                a.add((JsonElement)new JsonPrimitive(s));
            }
            json.add(name, (JsonElement)a);
            return defauld;
        }
        JsonArray array = e.getAsJsonArray();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < array.size(); ++i) {
            arrayList.add(array.get(i).getAsString());
        }
        return arrayList;
    }

    @Api.Stable(since="2.8.0")
    @Api.MixinsNotAllowed(where="CogwheelConfig#mixinsEntrypoint")
    public static synchronized void reload() {
        File config = new File(CogwheelHooks.getConfigFolder(), "cog/config-main.json");
        try (FileReader fr = new FileReader(config);
             Scanner sc = new Scanner(fr);){
            Iterator<Bi<ScriptLineHandler, Boolean>> buffer = new StringBuilder();
            while (sc.hasNextLine()) {
                String string = sc.nextLine();
                ((StringBuilder)((Object)buffer)).append(string).append('\n');
            }
            json = JsonParser.parseString((String)((StringBuilder)((Object)buffer)).toString()).getAsJsonObject();
        }
        catch (FileNotFoundException e) {
            CogwheelExecutor.log.error("[CFG] Failed to load config-main! Config files does not exist");
            try {
                if (!config.createNewFile()) {
                    throw new IOException("Failed to create config-main for unknown reasons");
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        catch (IOException e) {
            CogwheelExecutor.log.error("[CFG] Failed to load config-main! Default values will be used!", (Throwable)e);
        }
        catch (JsonParseException | IllegalStateException e) {
            CogwheelExecutor.log.error("[CFG] Failed to load config-main! Invalid format! Default values will be used!", e);
        }
        if (json == null) {
            json = new JsonObject();
        }
        json.addProperty("wiki", "https://storyanvil.github.io/wiki/wiki.html?p=wiki/projects/cogwheel/config");
        disableAllScripts = CogwheelConfig.getBool("disableAllScripts", false);
        disableBelt = CogwheelConfig.getBool("disableBelt", false);
        npcTalkingAnimation = CogwheelConfig.getBool("npcTalkingAnimation", true);
        monitorEnabled = CogwheelConfig.getBool("monitorEnabled", false);
        devEnvironment = CogwheelConfig.getBool("devEnvironment", true);
        List<String> disabledLineHandlers = CogwheelConfig.getStringArray("disableLineHandles", List.of());
        HashSet<class_2960> disabledLH = new HashSet<class_2960>();
        for (String string : disabledLineHandlers) {
            class_2960 rl = class_2960.method_12829((String)string);
            disabledLH.add(rl);
        }
        for (Bi<ScriptLineHandler, Boolean> bi : CogwheelRegistries.getLineHandlers()) {
            bi.setB(!disabledLH.contains(bi.getA().getIdentifier()));
        }
        CogwheelConfig.mixinsEntrypoint(json);
        try (FileWriter fw = new FileWriter(config);){
            try {
                StringWriter stringWriter = new StringWriter();
                JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
                jsonWriter.setLenient(true);
                jsonWriter.setIndent("    ");
                Streams.write((JsonElement)json, (JsonWriter)jsonWriter);
                fw.write(stringWriter.toString());
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
            fw.flush();
        }
        catch (IOException e) {
            CogwheelExecutor.log.error("[CFG] Failed to updated config-main!", (Throwable)e);
        }
        json = null;
        if (CogwheelHooks.getServer() != null) {
            for (class_3222 class_32222 : CogwheelHooks.getOverworldServer().method_8503().method_3760().method_14571()) {
                DevEarlySyncPacket.syncFor(class_32222, true);
            }
        }
        CogwheelExecutor.log.info("[CFG] Config reloaded!");
    }

    @Api.Stable(since="2.8.0")
    public static boolean isDisablingAllScripts() {
        return disableAllScripts;
    }

    @Api.Stable(since="2.8.0")
    public static boolean isDisablingBelt() {
        return disableBelt;
    }

    @Api.Stable(since="2.8.0")
    public static boolean isNpcTalkingAnimationEnabled() {
        return npcTalkingAnimation;
    }

    @Api.Stable(since="2.8.0")
    public static boolean isMonitorDisabled() {
        return !monitorEnabled;
    }

    @Api.Stable(since="2.8.0")
    public static boolean isDevEnvironment() {
        return devEnvironment;
    }

    @Api.Stable(since="2.8.0")
    @Api.MixinIntoHere
    public static void mixinsEntrypoint(JsonObject config) {
    }
}

