/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.data;

import com.storyanvil.cogwheel.api.Api;
import com.storyanvil.cogwheel.data.IStoryCodec;
import com.storyanvil.cogwheel.data.StoryCodecs;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.class_2540;

@Api.Experimental(since="2.10.0")
public final class StoryCodec<T>
implements IStoryCodec<T, class_2540> {
    private final BiConsumer<T, class_2540> encoder;
    private final Function<class_2540, T> decoder;
    private Object platformData;

    public StoryCodec(BiConsumer<T, class_2540> encoder, Function<class_2540, T> decoder) {
        this.encoder = encoder;
        this.decoder = decoder;
    }

    @Override
    @Api.Experimental(since="2.10.0")
    public void encode(T v, class_2540 buf) {
        this.encoder.accept(v, buf);
    }

    @Override
    @Api.Experimental(since="2.10.0")
    public T decode(class_2540 buf) {
        return this.decoder.apply(buf);
    }

    @Api.Experimental(since="2.10.0")
    public static <T> StoryCodec<T> fromIStoryCodec(IStoryCodec<T, class_2540> codec) {
        return new StoryCodec<Object>(codec::encode, codec::decode);
    }

    public StoryCodec<T> nullable() {
        return StoryCodecs.getNullableCodec(this);
    }

    @Api.PlatformTool
    public Object getPlatformData() {
        return this.platformData;
    }

    @Api.PlatformTool
    public void setPlatformData(Object platformData) {
        this.platformData = platformData;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        StoryCodec that = (StoryCodec)obj;
        return Objects.equals(this.encoder, that.encoder) && Objects.equals(this.decoder, that.decoder);
    }

    public int hashCode() {
        return Objects.hash(this.encoder, this.decoder);
    }

    public String toString() {
        return "StoryCodec[encoder=" + String.valueOf(this.encoder) + ", decoder=" + String.valueOf(this.decoder) + "]";
    }
}

