/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.data;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.storyanvil.cogwheel.data.CameraPos;
import com.storyanvil.cogwheel.data.StoryCodec;
import com.storyanvil.cogwheel.data.StoryCodecBldr;
import com.storyanvil.cogwheel.util.StoryUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1299;
import net.minecraft.class_1320;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_7225;
import net.minecraft.class_7923;

public class StoryCodecs {
    public static final StoryCodec<Boolean> BOOLEAN = new StoryCodec<Boolean>((a, b) -> b.method_52964(a.booleanValue()), class_2540::readBoolean);
    public static final StoryCodec<Byte> BYTE = new StoryCodec<Byte>((a, b) -> b.method_52997((int)a.byteValue()), class_2540::readByte);
    public static final StoryCodec<Integer> INTEGER = new StoryCodec<Integer>((a, b) -> b.method_53002(a.intValue()), class_2540::readInt);
    public static final StoryCodec<Long> LONG = new StoryCodec<Long>((a, b) -> b.method_52974(a.longValue()), class_2540::readLong);
    public static final StoryCodec<Float> FLOAT = new StoryCodec<Float>((a, b) -> b.method_52941(a.floatValue()), class_2540::readFloat);
    public static final StoryCodec<Double> DOUBLE = new StoryCodec<Double>((a, b) -> b.method_52940(a.doubleValue()), class_2540::readDouble);
    public static final StoryCodec<String> STRING = new StoryCodec<String>((a, b) -> StoryUtils.encodeString(b, a), StoryUtils::decodeString);
    public static final StoryCodec<JsonObject> JSON = new StoryCodec<JsonObject>((a, b) -> StoryUtils.encodeString(b, a.toString()), b -> JsonParser.parseString((String)StoryUtils.decodeString(b)).getAsJsonObject());
    public static final StoryCodec<class_2960> RESOURCE_LOC = new StoryCodec<class_2960>((a, b) -> {
        StoryUtils.encodeString(b, a.method_12836());
        StoryUtils.encodeString(b, a.method_12832());
    }, b -> class_2960.method_60655((String)StoryUtils.decodeString(b), (String)StoryUtils.decodeString(b)));
    public static final StoryCodec<class_2960> IDENTIFIER = RESOURCE_LOC;
    public static final StoryCodec<CameraPos> CAMERA_POS = new StoryCodec<CameraPos>(CameraPos::encode, CameraPos::decode);
    public static final StoryCodec<class_1792> ITEM = StoryCodecs.getRegistryCodec(class_7923.field_41178);
    public static final StoryCodec<class_2248> BLOCK = StoryCodecs.getRegistryCodec(class_7923.field_41175);
    public static final StoryCodec<class_1299<?>> ENTITY_TYPE = StoryCodecs.getRegistryCodec(class_7923.field_41177);
    public static final StoryCodec<class_1320> ATTRIBUTE = StoryCodecs.getRegistryCodec(class_7923.field_41190);
    public static final StoryCodec<class_2561> TEXT = StoryCodecBldr.build(StoryCodecBldr.Prop(t -> class_2561.class_2562.method_10867((class_2561)t, (class_7225.class_7874)class_310.method_1551().method_1562().method_29091()), STRING), s -> class_2561.class_2562.method_10877((String)s, (class_7225.class_7874)class_310.method_1551().method_1562().method_29091()));

    public static <T> StoryCodec<List<T>> getListCodec(StoryCodec<T> codec) {
        return new StoryCodec<List<T>>((ts, buf) -> {
            buf.method_53002(ts.size());
            for (int i = 0; i < ts.size(); ++i) {
                codec.encode((Object)ts.get(i), (class_2540)buf);
            }
        }, buf -> {
            int l = buf.readInt();
            ArrayList q = new ArrayList(l);
            for (int i = 0; i < l; ++i) {
                q.add(codec.decode((class_2540)buf));
            }
            return q;
        });
    }

    public static <T> StoryCodec<T> getRegistryCodec(class_2378<T> registry) {
        return StoryCodecBldr.build(StoryCodecBldr.String(o -> String.valueOf(registry.method_10221(o))), s -> registry.method_63535(class_2960.method_60654((String)s)));
    }

    public static <T> StoryCodec<T> getNullableCodec(StoryCodec<T> nonNullableCodec) {
        return new StoryCodec<Object>((t, buf) -> {
            if (t == null) {
                buf.method_52964(false);
                return;
            }
            buf.method_52964(true);
            nonNullableCodec.encode((Object)t, (class_2540)buf);
        }, buf -> {
            if (buf.readBoolean()) {
                return nonNullableCodec.decode((class_2540)buf);
            }
            return null;
        });
    }
}

