/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.entity;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import com.storyanvil.cogwheel.CogwheelExecutor;
import com.storyanvil.cogwheel.CogwheelHooks;
import com.storyanvil.cogwheel.api.Api;
import com.storyanvil.cogwheel.config.CogwheelConfig;
import com.storyanvil.cogwheel.infrastructure.ArgumentData;
import com.storyanvil.cogwheel.infrastructure.CGPM;
import com.storyanvil.cogwheel.infrastructure.StoryAction;
import com.storyanvil.cogwheel.infrastructure.abilities.DialogTarget;
import com.storyanvil.cogwheel.infrastructure.abilities.StoryActionQueue;
import com.storyanvil.cogwheel.infrastructure.abilities.StoryAnimator;
import com.storyanvil.cogwheel.infrastructure.abilities.StoryChatter;
import com.storyanvil.cogwheel.infrastructure.abilities.StoryModel;
import com.storyanvil.cogwheel.infrastructure.abilities.StoryNameHolder;
import com.storyanvil.cogwheel.infrastructure.abilities.StoryNavigator;
import com.storyanvil.cogwheel.infrastructure.abilities.StorySkinHolder;
import com.storyanvil.cogwheel.infrastructure.actions.AnimationAction;
import com.storyanvil.cogwheel.infrastructure.actions.PathfindAction;
import com.storyanvil.cogwheel.infrastructure.actions.WaitForLabelAction;
import com.storyanvil.cogwheel.infrastructure.cog.CogEntity;
import com.storyanvil.cogwheel.infrastructure.cog.CogEventCallback;
import com.storyanvil.cogwheel.infrastructure.cog.CogInteger;
import com.storyanvil.cogwheel.infrastructure.cog.CogPlayer;
import com.storyanvil.cogwheel.infrastructure.cog.CogString;
import com.storyanvil.cogwheel.infrastructure.cog.PreventSubCalling;
import com.storyanvil.cogwheel.infrastructure.cog.SubCallPostPrevention;
import com.storyanvil.cogwheel.infrastructure.env.CogScriptEnvironment;
import com.storyanvil.cogwheel.infrastructure.script.DispatchedScript;
import com.storyanvil.cogwheel.mixinAccess.IStoryEntity;
import com.storyanvil.cogwheel.network.devui.CogwheelNetwork;
import com.storyanvil.cogwheel.network.devui.DevOpenViewer;
import com.storyanvil.cogwheel.network.devui.inspector.InspectableEntity;
import com.storyanvil.cogwheel.network.mc.AnimationBound;
import com.storyanvil.cogwheel.network.mc.DialogBound;
import com.storyanvil.cogwheel.network.mc.DialogChoiceBound;
import com.storyanvil.cogwheel.util.DataStorage;
import com.storyanvil.cogwheel.util.EasyPropManager;
import com.storyanvil.cogwheel.util.ObjectMonitor;
import com.storyanvil.cogwheel.util.ScriptStorage;
import com.storyanvil.cogwheel.util.StoryUtils;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class NPC
extends class_1429
implements StoryActionQueue<NPC>,
StoryChatter,
StoryNameHolder,
StorySkinHolder,
StoryNavigator,
ObjectMonitor.IMonitored,
CGPM,
StoryAnimator,
GeoEntity,
StoryModel,
DialogTarget,
InspectableEntity {
    private static final ObjectMonitor<NPC> MONITOR = new ObjectMonitor();
    private final Queue<StoryAction<? extends NPC>> actionQueue = new ArrayDeque<StoryAction<? extends NPC>>();
    private StoryAction current;
    private CogEntity me;
    private long lastInteraction = 0L;
    @Api.PlatformTool
    public class_2960 platformModel = class_2960.method_60655((String)"storyanvil_cogwheel", (String)"geo/npc.geo.json");
    @Api.PlatformTool
    public class_2960 platformTexture = class_2960.method_60655((String)"storyanvil_cogwheel", (String)"textures/entity/npc/denisjava.png");
    private static final EasyPropManager MANAGER = new EasyPropManager("npc", NPC::registerProps);
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected static final RawAnimation WALK_ANIM = RawAnimation.begin().thenLoop("animation.npc.walk");
    private RawAnimation customAnimation = null;

    public NPC(class_1299<? extends class_1429> pEntityType, class_1937 pLevel) {
        super(pEntityType, pLevel);
        MONITOR.register(this);
        if (!pLevel.field_9236) {
            this.me = new CogEntity((class_1297)this);
            this.setSkin(DataStorage.getString((class_1297)this, "skin", "test"));
            this.setCustomName(DataStorage.getString((class_1297)this, "name", "NPC"));
            this.setStoryModelID(DataStorage.getString((class_1297)this, "model", "npc"));
            this.storyEntity().storyEntity$putString("rightclick", this.storyEntity().storyEntity$getString("rightclick", ""));
            this.storyEntity().storyEntity$putString("leftclick", this.storyEntity().storyEntity$getString("leftclick", ""));
        }
    }

    public IStoryEntity storyEntity() {
        return (IStoryEntity)((Object)this);
    }

    public boolean method_6481(class_1799 stack) {
        return false;
    }

    @NotNull
    public class_1269 method_5992(@NotNull class_1657 plr, @NotNull class_1268 hand) {
        String action = this.storyEntity().storyEntity$getString("rigthclick", "");
        if (plr instanceof class_3222) {
            class_3222 player = (class_3222)plr;
            if (!action.isEmpty()) {
                long time = System.currentTimeMillis();
                if (time - this.lastInteraction < 250L) {
                    return class_1269.field_5814;
                }
                this.lastInteraction = time;
                CogScriptEnvironment.dispatchScriptGlobal(action, new ScriptStorage().append("internal_callback", new CogEventCallback()).append("event_player", new CogPlayer(new WeakReference<class_3222>(player))).append("event_npc", this));
                return class_1269.field_21466;
            }
        }
        return super.method_5992(plr, hand);
    }

    public void interact(class_3222 plr) {
        String action = this.storyEntity().storyEntity$getString("leftclick", "");
        if (action.isEmpty()) {
            return;
        }
        long time = System.currentTimeMillis();
        if (time - this.lastInteraction < 250L) {
            return;
        }
        this.lastInteraction = time;
        CogScriptEnvironment.dispatchScriptGlobal(action, new ScriptStorage().append("internal_callback", new CogEventCallback()).append("event_player", new CogPlayer(new WeakReference<class_3222>(plr))).append("event_npc", this));
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236) {
            if (this.current != null) {
                if (this.current.freeToGo(this)) {
                    this.current = null;
                }
            } else {
                if (this.actionQueue.isEmpty()) {
                    return;
                }
                this.current = this.actionQueue.remove();
                this.current.proceed(this);
            }
        }
    }

    @Api.Stable(since="2.0.0")
    @Nullable
    public class_2561 method_5797() {
        return class_2561.method_43470((String)this.getCogName());
    }

    @Override
    @Api.Stable(since="2.0.0")
    public String getCogName() {
        return this.storyEntity().storyEntity$getString("name", "NPC");
    }

    @Override
    @Api.Stable(since="2.0.0")
    public void setCogName(String name) {
        this.storyEntity().storyEntity$putString("name", name);
    }

    @Api.Stable(since="2.0.0")
    public void method_5665(@Nullable class_2561 pName) {
        this.storyEntity().storyEntity$putString("name", pName == null ? "" : pName.getString());
    }

    @Api.Stable(since="2.0.0")
    public void setCustomName(@Nullable String pName) {
        this.storyEntity().storyEntity$putString("name", pName == null ? "" : pName);
    }

    @Api.Internal
    @ApiStatus.Internal
    public static class_5132.class_5133 createAttributes() {
        return class_1429.method_26827().method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23717, 24.0).method_26868(class_5134.field_23719, (double)0.1f);
    }

    public void method_5982() {
    }

    @Override
    @Api.Stable(since="2.0.0")
    public String getSkin() {
        return this.storyEntity().storyEntity$getString("skin", "test");
    }

    @Override
    @Api.Stable(since="2.0.0")
    public void setSkin(String skin) {
        this.storyEntity().storyEntity$putString("skin", skin);
        this.platformTexture = class_2960.method_60655((String)"storyanvil_cogwheel", (String)("textures/entity/npc/" + this.getSkin() + ".png"));
    }

    @Override
    @Api.Stable(since="2.0.0")
    public void chat(String text) {
        if (!this.method_37908().field_9236) {
            class_5250 c = class_2561.method_43470((String)("[" + this.getCogName() + "] " + text));
            for (class_3222 player : ((class_3218)this.method_37908()).method_18456()) {
                player.method_64398((class_2561)c);
            }
        }
    }

    @Override
    @Api.Stable(since="2.0.0")
    public synchronized <R> void addStoryAction(StoryAction<R> action) {
        this.actionQueue.add(action);
    }

    @Override
    @Api.Stable(since="2.0.0")
    public void reportState(StringBuilder sb) {
        for (StoryAction storyAction : this.actionQueue) {
            sb.append(storyAction.toString());
        }
        sb.append(">").append(this.current.toString());
        sb.append(" | ").append(this);
    }

    private static void registerProps(EasyPropManager manager) {
        manager.reg("setName", (name, args, script, o) -> {
            NPC npc = (NPC)o;
            return npc.addChained(new StoryAction.Instant<NPC>(){

                @Override
                public void proceed(NPC myself) {
                    myself.setCogName(args.get(0).convertToString());
                }
            });
        });
        manager.reg("getName", (name, args, script, o) -> new CogString(((NPC)o).getCogName()));
        manager.reg("setSkin", (name, args, script, o) -> {
            NPC npc = (NPC)o;
            return npc.addChained(new StoryAction.Instant<NPC>(){

                @Override
                public void proceed(NPC myself) {
                    myself.setSkin(args.get(0).convertToString());
                }
            });
        });
        manager.reg("getSkin", (name, args, script, o) -> new CogString(((NPC)o).getSkin()));
        manager.reg("setModel", (name, args, script, o) -> {
            NPC npc = (NPC)o;
            return npc.addChained(new StoryAction.Instant<NPC>(){

                @Override
                public void proceed(NPC myself) {
                    myself.setStoryModelID(args.get(0).convertToString());
                }
            });
        });
        manager.reg("getModel", (name, args, script, o) -> new CogString(((NPC)o).getStoryModelID()));
        manager.reg("chat", (name, args, script, o) -> {
            NPC npc = (NPC)o;
            return npc.addChained(new StoryAction.Instant<NPC>(){

                @Override
                public void proceed(NPC myself) {
                    myself.chat(args.get(0).convertToString());
                }
            });
        });
        manager.reg("pathfind", (name, args, script, o) -> {
            NPC npc = (NPC)o;
            return npc.addChained(new PathfindAction(new class_2338(args.requireInt(0), args.requireInt(1), args.requireInt(2))));
        });
        manager.reg("waitForLabel", (name, args, script, o) -> {
            NPC npc = (NPC)o;
            if (args.size() == 1) {
                return npc.addChained(new WaitForLabelAction(args.getString(0)));
            }
            return npc.addChained(new WaitForLabelAction(args.getString(0), args.requireInt(1)));
        });
        manager.reg("animation", (name, args, script, o) -> {
            NPC npc = (NPC)o;
            return npc.addChained(new AnimationAction(args.getString(0), args.requireInt(1)));
        });
        manager.reg("dialogChoices", (name, args, script, o) -> {
            NPC npc = (NPC)o;
            final String dialogID = UUID.randomUUID().toString();
            final class_2561[] Texts = new class_2561[args.size()];
            for (int i = 0; i < Texts.length; ++i) {
                Texts[i] = class_2561.method_43470((String)("[" + (i + 1) + "] ")).method_27696(class_2583.field_24360.method_10977(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)args.getString(i)).method_27696(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11750, "/@storyclient dialog " + i + " " + dialogID)).method_10977(class_124.field_1068)));
            }
            npc.addStoryAction(new StoryAction.Instant<NPC>(){

                @Override
                public void proceed(NPC myself) {
                    CogwheelExecutor.scheduleTickEvent(event -> StoryUtils.sendGlobalMessage(event, Texts));
                }
            });
            throw new PreventSubCalling(new SubCallPostPrevention(){

                @Override
                public void prevent(String variable) {
                    CogwheelExecutor.getDefaultEnvironment().registerDialog(dialogID, response -> CogwheelExecutor.schedule(() -> {
                        script.put(variable, new CogInteger((int)response));
                        script.lineDispatcher();
                    }));
                }
            });
        });
        manager.reg("dialogBlocking", (name, args, script, o) -> {
            final NPC npc = (NPC)o;
            final DialogBound bound = new DialogBound(args.getString(0), npc.getCogName(), args.getString(1));
            npc.addStoryAction(new StoryAction.Ticking<NPC>(args.requireInt(2)){

                @Override
                public void proceed(NPC myself) {
                    CogwheelHooks.sendPacketToEveryone(bound);
                    CogwheelHooks.sendPacketToEveryone(new AnimationBound(myself.getAnimatorID(), "animation.npc.talk"));
                }
            });
            throw new PreventSubCalling(new SubCallPostPrevention(){

                @Override
                public void prevent(String variable) {
                    CogwheelExecutor.scheduleTickEvent(e -> {
                        script.put(variable, CGPM.nullManager);
                        CogwheelHooks.sendPacketToEveryone(new DialogBound());
                        if (CogwheelConfig.isNpcTalkingAnimationEnabled()) {
                            CogwheelHooks.sendPacketToEveryone(new AnimationBound(npc.getAnimatorID(), "null"));
                        }
                        CogwheelExecutor.schedule(script::lineDispatcher);
                    }, args.requireInt(2));
                }
            });
        });
        manager.reg("dialogNonBlocking", (name, args, script, o) -> {
            final NPC npc = (NPC)o;
            final DialogBound bound = new DialogBound(args.getString(0), npc.getCogName(), args.getString(1));
            return npc.addChained(new StoryAction.Ticking<NPC>(args.requireInt(2)){

                @Override
                public void proceed(NPC myself) {
                    CogwheelHooks.sendPacketToEveryone(bound);
                    CogwheelHooks.sendPacketToEveryone(new AnimationBound(myself.getAnimatorID(), "animation.npc.talk"));
                }

                @Override
                public void onEnding() {
                    CogwheelHooks.sendPacketToEveryone(new DialogBound());
                    if (CogwheelConfig.isNpcTalkingAnimationEnabled()) {
                        CogwheelHooks.sendPacketToEveryone(new AnimationBound(npc.getAnimatorID(), "null"));
                    }
                }
            });
        });
        manager.reg("dialogChoiceUI", (name, args, script, o) -> {
            NPC npc = (NPC)o;
            final String dialogID = UUID.randomUUID().toString();
            int optionsLength = args.size() - 1;
            String[] options = new String[optionsLength - 1];
            for (int i = 0; i < optionsLength - 1; ++i) {
                options[i] = args.getString(i + 1);
            }
            final DialogChoiceBound bound = new DialogChoiceBound(dialogID, args.getString(0), options, npc.getCogName(), args.getString(optionsLength));
            npc.addStoryAction(new StoryAction.Instant<NPC>(){

                @Override
                public void proceed(NPC myself) {
                    CogwheelExecutor.scheduleTickEvent(event -> CogwheelHooks.sendPacketToEveryone(bound));
                }
            });
            throw new PreventSubCalling(new SubCallPostPrevention(){

                @Override
                public void prevent(String variable) {
                    CogwheelExecutor.getDefaultEnvironment().registerDialog(dialogID, response -> CogwheelExecutor.schedule(() -> {
                        CogwheelExecutor.scheduleTickEvent(levelTickEvent -> CogwheelHooks.sendPacketToEveryone(new DialogChoiceBound()));
                        script.put(variable, new CogInteger((int)response));
                        CogwheelExecutor.schedule(script::lineDispatcher);
                    }));
                }
            });
        });
        manager.reg("setRightClick", (name, args, script, o) -> {
            NPC npc = (NPC)o;
            CogwheelExecutor.scheduleTickEvent(levelTickEvent -> npc.storyEntity().storyEntity$putString("rightclick", args.getString(0)));
            return null;
        });
        manager.reg("setLeftClick", (name, args, script, o) -> {
            NPC npc = (NPC)o;
            CogwheelExecutor.scheduleTickEvent(levelTickEvent -> npc.storyEntity().storyEntity$putString("leftclick", args.getString(0)));
            return null;
        });
    }

    @Override
    @Api.Stable(since="2.0.0")
    public boolean hasOwnProperty(String name) {
        if (this.me.hasOwnProperty(name)) {
            return true;
        }
        return MANAGER.hasOwnProperty(name);
    }

    @Override
    @Api.Stable(since="2.0.0")
    @Nullable
    public CGPM getProperty(String name, ArgumentData args, DispatchedScript script) {
        if (this.me.hasOwnProperty(name)) {
            return this.me.getProperty(name, args, script);
        }
        return MANAGER.get(name).handle(name, args, script, this);
    }

    @Override
    @Api.Stable(since="2.0.0")
    public boolean equalsTo(CGPM o) {
        return false;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "walking", this::walkAnim));
    }

    protected <E extends NPC> PlayState walkAnim(AnimationState<E> event) {
        if (this.customAnimation != null) {
            return event.setAndContinue(this.customAnimation);
        }
        if (event.isMoving()) {
            return event.setAndContinue(WALK_ANIM);
        }
        return PlayState.STOP;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    @Override
    public String getAnimatorID() {
        return this.method_5845();
    }

    @Override
    @Api.Stable(since="2.0.0")
    public void pushAnimation(String name) {
        if (name.equals("null")) {
            this.customAnimation = null;
            return;
        }
        this.customAnimation = RawAnimation.begin().thenLoop(name);
    }

    @Override
    public String getStoryModelID() {
        return this.storyEntity().storyEntity$getString("model", "npc");
    }

    @Override
    public void setStoryModelID(String id) {
        this.storyEntity().storyEntity$putString("model", id);
    }

    @Override
    public void d$say(String text, String texture, int ticks, final Runnable trigger) {
        final DialogBound bound = new DialogBound(text, this.getCogName(), texture);
        this.addStoryAction(new StoryAction.Ticking<NPC>(ticks){

            @Override
            public void proceed(NPC myself) {
                CogwheelHooks.sendPacketToEveryone(bound);
                CogwheelHooks.sendPacketToEveryone(new AnimationBound(myself.getAnimatorID(), "animation.npc.talk"));
            }

            @Override
            public void onEnding() {
                CogwheelHooks.sendPacketToEveryone(new DialogBound());
                if (CogwheelConfig.isNpcTalkingAnimationEnabled()) {
                    CogwheelHooks.sendPacketToEveryone(new AnimationBound(NPC.this.getAnimatorID(), "null"));
                }
                CogwheelExecutor.schedule(trigger);
            }
        });
    }

    @Override
    public void d$ask(String text, String texture, List<String> options, Consumer<Integer> acceptor) {
        String dialogID = UUID.randomUUID().toString();
        final DialogChoiceBound bound = new DialogChoiceBound(dialogID, text, options, this.getCogName(), texture);
        this.addStoryAction(new StoryAction.Instant<NPC>(this){

            @Override
            public void proceed(NPC myself) {
                CogwheelExecutor.scheduleTickEvent(levelTickEvent -> CogwheelHooks.sendPacketToEveryone(bound));
            }
        });
        CogwheelExecutor.getDefaultEnvironment().registerDialog(dialogID, response -> CogwheelExecutor.schedule(() -> {
            CogwheelExecutor.scheduleTickEvent(levelTickEvent -> CogwheelHooks.sendPacketToEveryone(new DialogChoiceBound()));
            acceptor.accept((Integer)response);
        }));
    }

    @Override
    public String d$name() {
        return this.getCogName();
    }

    @Override
    public synchronized boolean tryToInspect(@NotNull class_3218 level, @NotNull class_3222 player) {
        JsonObject obj = new JsonObject();
        obj.addProperty("uuid", this.method_5845());
        obj.addProperty("animatorID", this.getAnimatorID());
        obj.addProperty("skinID", this.getSkin());
        obj.addProperty("modelID", this.getStoryModelID());
        JsonArray array = new JsonArray();
        for (StoryAction storyAction : this.actionQueue) {
            array.add((JsonElement)storyAction.toJSON());
        }
        obj.add("storyActions", (JsonElement)array);
        if (this.current != null) {
            obj.add("currentStoryAction", (JsonElement)this.current.toJSON());
        } else {
            obj.add("currentStoryAction", null);
        }
        try {
            StringWriter stringWriter = new StringWriter();
            JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
            jsonWriter.setLenient(true);
            jsonWriter.setIndent("    ");
            jsonWriter.setSerializeNulls(true);
            Streams.write((JsonElement)obj, (JsonWriter)jsonWriter);
            CogwheelNetwork.sendFromServer(player, new DevOpenViewer("npc.json", stringWriter.toString()));
            return true;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return null;
    }
}

