/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.fabric;

import com.mojang.brigadier.CommandDispatcher;
import com.storyanvil.cogwheel.CogwheelEngine;
import com.storyanvil.cogwheel.CogwheelHooks;
import com.storyanvil.cogwheel.EventBus;
import com.storyanvil.cogwheel.data.StoryCodec;
import com.storyanvil.cogwheel.data.StoryPacket;
import com.storyanvil.cogwheel.entity.NPC;
import com.storyanvil.cogwheel.fabric.FabricRegistry;
import com.storyanvil.cogwheel.fabric.data.StoryFabricPacket;
import com.storyanvil.cogwheel.network.devui.DevEarlySyncPacket;
import com.storyanvil.cogwheel.network.devui.editor.DevEditorSession;
import com.storyanvil.cogwheel.network.mc.AnimationDataBound;
import com.storyanvil.cogwheel.util.Bi;
import dev.architectury.event.events.client.ClientTickEvent;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3244;
import net.minecraft.class_5132;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CogwheelEngineFabric
implements ModInitializer {
    public static final Logger PLATFORM_LOG = LoggerFactory.getLogger((String)"STORYANVIL/COGWHEEL/FABRICMC");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void onServerTick(MinecraftServer server) {
        List<Bi<Consumer<class_3218>, Integer>> list = EventBus.queue;
        synchronized (list) {
            class_3218 world = CogwheelHooks.getOverworldServer();
            try {
                for (int i = 0; i < EventBus.queue.size(); ++i) {
                    Bi<Consumer<class_3218>, Integer> e = EventBus.queue.get(i);
                    if (e.getB() < 2) {
                        try {
                            e.getA().accept(world);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        EventBus.queue.remove(i);
                        --i;
                        continue;
                    }
                    e.setB(e.getB() - 1);
                }
            }
            catch (Exception e) {
                CogwheelEngine.LOGGER.warn("Queue bound error", (Throwable)e);
            }
            try {
                EventBus.getStoryLevel().tick(world);
            }
            catch (Exception e) {
                CogwheelEngine.LOGGER.warn("StoryLevel onClientTick error", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void onClientTick(class_638 world) {
        if (!((class_5321)world.method_40134().method_40230().get()).method_29177().equals((Object)class_2960.method_60655((String)"minecraft", (String)"overworld"))) {
            return;
        }
        List<Bi<Consumer<class_638>, Integer>> list = EventBus.clientQueue;
        synchronized (list) {
            try {
                for (int i = 0; i < EventBus.clientQueue.size(); ++i) {
                    Bi<Consumer<class_638>, Integer> e = EventBus.clientQueue.get(i);
                    if (e.getB() < 2) {
                        e.getA().accept(world);
                        EventBus.clientQueue.remove(i);
                        --i;
                        continue;
                    }
                    e.setB(e.getB() - 1);
                }
            }
            catch (Exception e) {
                CogwheelEngine.LOGGER.warn("Client Queue bound error", (Throwable)e);
            }
            return;
        }
    }

    private static void onBoundEvent(class_3244 netHandler, PacketSender sender, MinecraftServer server) {
        StringBuilder sb = new StringBuilder();
        boolean a = true;
        for (class_2960 loc : EventBus.serverSideAnimations) {
            if (a) {
                a = false;
            } else {
                sb.append("|");
            }
            sb.append(loc.toString());
        }
        CogwheelHooks.sendPacket(new AnimationDataBound(sb.toString()), netHandler.field_14140);
        DevEarlySyncPacket.syncFor(netHandler.field_14140, true);
        DevEditorSession.boundColorFor(netHandler.field_14140);
    }

    private static void onUnboundEvent(class_3244 handler, MinecraftServer server) {
        DevEditorSession.unboundColorFrom(handler.field_14140);
    }

    private static void onServerStarting(MinecraftServer server) {
        CogwheelHooks.serverStart();
    }

    private static void onServerStopping(MinecraftServer server) {
        CogwheelHooks.serverStop();
    }

    public void onInitialize() {
        CogwheelEngine.init();
        FabricRegistry.initialize();
        CommandRegistrationCallback.EVENT.register((d, ra, e) -> CogwheelHooks.commandRegistry(arg_0 -> ((CommandDispatcher)d).register(arg_0)));
        ServerTickEvents.END_SERVER_TICK.register(CogwheelEngineFabric::onServerTick);
        ClientTickEvent.CLIENT_LEVEL_POST.register(CogwheelEngineFabric::onClientTick);
        ServerPlayConnectionEvents.JOIN.register(CogwheelEngineFabric::onBoundEvent);
        ServerPlayConnectionEvents.DISCONNECT.register(CogwheelEngineFabric::onUnboundEvent);
        ServerLifecycleEvents.SERVER_STARTED.register(CogwheelEngineFabric::onServerStarting);
        ServerLifecycleEvents.SERVER_STOPPING.register(CogwheelEngineFabric::onServerStopping);
        FabricDefaultAttributeRegistry.register(FabricRegistry.NPC, (class_5132.class_5133)NPC.createAttributes());
        CogwheelHooks.packetRegistry(new CogwheelHooks.PacketRegistrar(this){

            @Override
            public <T extends StoryPacket<T>> void accept(String id, StoryCodec<T> codec, Class<T> clazz) {
                id = id.toLowerCase(Locale.ENGLISH);
                StoryFabricPacket<T> packet = new StoryFabricPacket<T>(id, codec);
                PayloadTypeRegistry.playC2S().register(packet.getType().comp_2243(), packet);
                PayloadTypeRegistry.playS2C().register(packet.getType().comp_2243(), packet);
                ClientPlayNetworking.registerGlobalReceiver((class_8710.class_9154)packet.getType().comp_2243(), packet::handleClient);
                ServerPlayNetworking.registerGlobalReceiver((class_8710.class_9154)packet.getType().comp_2243(), packet::handleServer);
                PLATFORM_LOG.debug("Registered packet {} with [id={},class={}]", new Object[]{packet, id, clazz});
            }
        });
    }
}

