/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.infrastructure;

import com.storyanvil.cogwheel.infrastructure.CGPM;
import com.storyanvil.cogwheel.infrastructure.cog.CogBool;
import com.storyanvil.cogwheel.infrastructure.cog.CogDouble;
import com.storyanvil.cogwheel.infrastructure.cog.CogInteger;
import com.storyanvil.cogwheel.infrastructure.cog.CogInvoker;
import com.storyanvil.cogwheel.infrastructure.cog.CogLong;
import com.storyanvil.cogwheel.infrastructure.cog.CogPrimalType;
import com.storyanvil.cogwheel.infrastructure.cog.CogString;
import com.storyanvil.cogwheel.infrastructure.script.DispatchedScript;
import com.storyanvil.cogwheel.registry.CogwheelRegistries;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class ArgumentData {
    private final CGPM[] args;
    private final DispatchedScript script;
    private final String full;

    @Contract(pure=true)
    private ArgumentData(CGPM[] args, String full, DispatchedScript script) {
        this.full = full;
        this.args = args;
        this.script = script;
    }

    public CGPM get(int argument) {
        if (argument >= this.args.length) {
            throw new RuntimeException("Not enough arguments: contains only " + this.args.length + " but " + argument + " is needed!");
        }
        return this.args[argument];
    }

    public CogPrimalType requirePrimal(int argument) {
        CGPM m = this.get(argument);
        if (m instanceof CogPrimalType) {
            CogPrimalType i = (CogPrimalType)m;
            return i;
        }
        throw new RuntimeException("Argument #" + argument + " is not primal type");
    }

    public int requireInt(int argument) {
        CGPM m = this.get(argument);
        if (m instanceof CogInteger) {
            CogInteger i = (CogInteger)m;
            return i.getValue();
        }
        throw new RuntimeException("Argument #" + argument + " is not CogInteger");
    }

    public CogInvoker requireInvoker(int argument) {
        CGPM m = this.get(argument);
        if (m instanceof CogInvoker) {
            CogInvoker i = (CogInvoker)m;
            return i;
        }
        throw new RuntimeException("Argument #" + argument + " is not CogInvoker");
    }

    public long requireLong(int argument) {
        CGPM m = this.get(argument);
        if (m instanceof CogLong) {
            CogLong i = (CogLong)m;
            return i.getValue();
        }
        throw new RuntimeException("Argument #" + argument + " is not CogLong");
    }

    public boolean requireBoolean(int argument) {
        CGPM m = this.get(argument);
        if (m instanceof CogBool) {
            CogBool i = (CogBool)m;
            return i.getValue();
        }
        throw new RuntimeException("Argument #" + argument + " is not CogBool");
    }

    public double requireDouble(int argument) {
        CGPM m = this.get(argument);
        if (m instanceof CogDouble) {
            CogDouble i = (CogDouble)m;
            return i.getValue();
        }
        if (m instanceof CogInteger) {
            CogInteger i = (CogInteger)m;
            return i.getValue();
        }
        throw new RuntimeException("Argument #" + argument + " is not CogDouble");
    }

    public double requireDoubleOrInt(int argument) {
        CGPM m = this.get(argument);
        if (m instanceof CogDouble) {
            CogDouble i = (CogDouble)m;
            return i.getValue();
        }
        if (m instanceof CogInteger) {
            CogInteger i = (CogInteger)m;
            return i.getValue();
        }
        throw new RuntimeException("Argument #" + argument + " is not CogDouble/CogInteger");
    }

    public String getString(int argument) {
        CGPM m = this.get(argument);
        return m.convertToString();
    }

    public CogString getCogString(int argument) {
        CGPM m = this.get(argument);
        if (m instanceof CogString) {
            CogString string = (CogString)m;
            return string;
        }
        return m.convertToCogString();
    }

    public DispatchedScript getScript() {
        return this.script;
    }

    public CGPM[] getArgs() {
        return this.args;
    }

    public String getFull() {
        return this.full;
    }

    public int size() {
        return this.args.length;
    }

    @Contract(value="_, _ -> new", pure=false)
    @NotNull
    public static ArgumentData of(@NotNull String str, DispatchedScript script) {
        ArrayList<String> expressions = new ArrayList<String>();
        boolean quotes = false;
        int level = 0;
        int start = 0;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\"') {
                quotes = !quotes;
                continue;
            }
            if (quotes) continue;
            if (c == '(') {
                ++level;
                continue;
            }
            if (c == ')') {
                --level;
                continue;
            }
            if (c != ',' || level != 0) continue;
            expressions.add(str.substring(start, i));
            start = i + 1;
        }
        expressions.add(str.substring(start));
        CGPM[] managers = new CGPM[expressions.size()];
        for (int i = 0; i < managers.length; ++i) {
            managers[i] = CGPM.noNull(CogwheelRegistries.expressionHandler((String)expressions.get(i), script, false).getB());
        }
        return new ArgumentData(managers, str, script);
    }

    @NotNull
    public static ArgumentData of(DispatchedScript script, CGPM a1) {
        return new ArgumentData(new CGPM[]{a1}, null, script);
    }

    @NotNull
    public static ArgumentData of(DispatchedScript script, CGPM a1, CGPM a2) {
        return new ArgumentData(new CGPM[]{a1, a2}, null, script);
    }

    @NotNull
    public static ArgumentData of(DispatchedScript script, CGPM a1, CGPM a2, CGPM a3) {
        return new ArgumentData(new CGPM[]{a1, a2, a3}, null, script);
    }

    @NotNull
    public static ArgumentData of(DispatchedScript script, CGPM ... a) {
        return new ArgumentData(a, null, script);
    }

    public String toString() {
        return "ArgumentData{args=" + Arrays.toString(this.args) + ", script=" + String.valueOf(this.script) + "}";
    }
}

