/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.infrastructure;

import com.storyanvil.cogwheel.infrastructure.ArgumentData;
import com.storyanvil.cogwheel.infrastructure.cog.CogLike;
import com.storyanvil.cogwheel.infrastructure.cog.CogString;
import com.storyanvil.cogwheel.infrastructure.cog.PreventSubCalling;
import com.storyanvil.cogwheel.infrastructure.script.DispatchedScript;
import com.storyanvil.cogwheel.infrastructure.testing.TestIgnoreDocs;
import com.storyanvil.cogwheel.util.EasyPropManager;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@TestIgnoreDocs
public interface CGPM
extends CogLike {
    public static final NullManager nullManager = new NullManager();

    public boolean hasOwnProperty(String var1);

    @Nullable
    public CGPM getProperty(String var1, ArgumentData var2, DispatchedScript var3) throws PreventSubCalling;

    public boolean equalsTo(CGPM var1);

    @Contract(value="!null -> param1", pure=true)
    @NotNull
    public static CGPM noNull(@Nullable CGPM manager) {
        if (manager == null) {
            return nullManager;
        }
        return manager;
    }

    default public String convertToString() {
        return this.toString();
    }

    default public CogString convertToCogString() {
        return new CogString(this.convertToString());
    }

    @Override
    default public CGPM asCogManager() {
        return this;
    }

    default public boolean isNull() {
        return this instanceof NullManager;
    }

    public static class NullManager
    implements CGPM {
        private static final EasyPropManager MANAGER = new EasyPropManager("nil", NullManager::registerProps);

        private static void registerProps(EasyPropManager manager) {
        }

        @Contract(pure=true)
        private NullManager() {
        }

        @Override
        public boolean hasOwnProperty(String name) {
            return MANAGER.hasOwnProperty(name);
        }

        @Override
        @Nullable
        public CGPM getProperty(String name, ArgumentData args, DispatchedScript script) {
            return MANAGER.get(name).handle(name, args, script, this);
        }

        @Override
        public boolean equalsTo(CGPM o) {
            return o instanceof NullManager;
        }

        @Override
        public String convertToString() {
            return "NULL";
        }
    }
}

