/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.infrastructure.cog;

import com.storyanvil.cogwheel.api.Api;
import com.storyanvil.cogwheel.infrastructure.ArgumentData;
import com.storyanvil.cogwheel.infrastructure.CGPM;
import com.storyanvil.cogwheel.infrastructure.cog.CogPrimalType;
import com.storyanvil.cogwheel.infrastructure.script.DispatchedScript;
import com.storyanvil.cogwheel.util.EasyPropManager;
import net.minecraft.class_2487;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CogBool
implements CGPM,
CogPrimalType {
    private static final EasyPropManager MANAGER = new EasyPropManager("bool", CogBool::registerProps);
    @Api.Stable(since="2.0.0")
    public static final CogBool TRUE = new CogBool(true);
    @Api.Stable(since="2.0.0")
    public static final CogBool FALSE = new CogBool(false);
    private boolean value;

    @Contract(pure=true)
    @Api.Stable(since="2.0.0")
    public static CogBool getInstance(boolean value) {
        return value ? TRUE : FALSE;
    }

    private static void registerProps(@NotNull EasyPropManager manager) {
        manager.reg("not", (name, args, script, o) -> {
            CogBool bool = (CogBool)o;
            if (bool.value) {
                return FALSE;
            }
            return TRUE;
        });
        manager.reg("and", (name, args, script, o) -> {
            CogBool bool = (CogBool)o;
            return CogBool.getInstance(args.requireBoolean(0) && bool.value);
        });
        manager.reg("or", (name, args, script, o) -> {
            CogBool bool = (CogBool)o;
            return CogBool.getInstance(args.requireBoolean(0) || bool.value);
        });
        manager.reg("xor", (name, args, script, o) -> {
            CogBool bool = (CogBool)o;
            return CogBool.getInstance(args.requireBoolean(0) != bool.value);
        });
    }

    @Contract(pure=true)
    private CogBool(boolean value) {
        this.value = value;
    }

    @Override
    public boolean hasOwnProperty(String name) {
        return MANAGER.hasOwnProperty(name);
    }

    @Override
    @Nullable
    public CGPM getProperty(String name, ArgumentData args, DispatchedScript script) {
        return MANAGER.get(name).handle(name, args, script, this);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public String convertToString() {
        return this.value ? "TRUE" : "FALSE";
    }

    @Contract(pure=true)
    public boolean getValue() {
        return this.value;
    }

    @Override
    @Contract(value="null -> false", pure=true)
    public boolean equalsTo(CGPM o) {
        if (o instanceof CogBool) {
            CogBool other = (CogBool)o;
            return other.value == this.value;
        }
        return false;
    }

    @Contract(pure=true)
    public int hashCode() {
        return this.value ? 0 : 1;
    }

    @Override
    @Contract(pure=true)
    public byte getPrimalID() {
        return 38;
    }

    @Override
    public void putPrimal(@NotNull class_2487 tag, String key) {
        tag.method_10556(key, this.value);
    }

    @Override
    public Object getObjValue() {
        return this.value;
    }
}

