/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.infrastructure.cog;

import com.storyanvil.cogwheel.api.Api;
import com.storyanvil.cogwheel.infrastructure.ArgumentData;
import com.storyanvil.cogwheel.infrastructure.CGPM;
import com.storyanvil.cogwheel.infrastructure.cog.CogArray;
import com.storyanvil.cogwheel.infrastructure.cog.CogBool;
import com.storyanvil.cogwheel.infrastructure.cog.CogDouble;
import com.storyanvil.cogwheel.infrastructure.cog.CogInteger;
import com.storyanvil.cogwheel.infrastructure.cog.CogLong;
import com.storyanvil.cogwheel.infrastructure.cog.CogString;
import com.storyanvil.cogwheel.infrastructure.script.DispatchedScript;
import com.storyanvil.cogwheel.util.DataStorage;
import com.storyanvil.cogwheel.util.EasyPropManager;
import java.lang.ref.WeakReference;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_3218;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CogEntity
implements CGPM {
    private static final EasyPropManager MANAGER = new EasyPropManager("entity", CogEntity::registerProps);
    private final WeakReference<class_1297> e;

    private static void registerProps(@NotNull EasyPropManager manager) {
        manager.reg("getEntityType", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            return new CogString(class_7923.field_41177.method_10221((Object)CogEntity.unsafeEntity(e).method_5864()).toString());
        });
        manager.reg("getUUID", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            return new CogString(CogEntity.unsafeEntity(e).method_5845());
        });
        manager.reg("toEntity", (name, args, script, o) -> (CogEntity)o);
        manager.reg("teleport", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            CogEntity.unsafeEntity(e).method_5859(args.requireDoubleOrInt(0), args.requireDoubleOrInt(1), args.requireDoubleOrInt(2));
            return e;
        });
        manager.reg("turn", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            CogEntity.unsafeEntity(e).method_64578((float)args.requireDoubleOrInt(0), (float)args.requireDoubleOrInt(1));
            return e;
        });
        manager.reg("teleport2", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            CogEntity.unsafeEntity(e).method_5859(args.requireDoubleOrInt(0), args.requireDoubleOrInt(1), args.requireDoubleOrInt(2));
            CogEntity.unsafeEntity(e).method_64578((float)args.requireDoubleOrInt(3), (float)args.requireDoubleOrInt(4));
            return e;
        });
        manager.reg("getX", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            return new CogDouble(CogEntity.unsafeEntity(e).method_23317());
        });
        manager.reg("getY", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            return new CogDouble(CogEntity.unsafeEntity(e).method_23318());
        });
        manager.reg("getZ", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            return new CogDouble(CogEntity.unsafeEntity(e).method_23321());
        });
        manager.reg("getBlockX", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            return new CogInteger(CogEntity.unsafeEntity(e).method_31477());
        });
        manager.reg("getBlockY", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            return new CogInteger(CogEntity.unsafeEntity(e).method_31478());
        });
        manager.reg("getBlockZ", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            return new CogInteger(CogEntity.unsafeEntity(e).method_31479());
        });
        manager.reg("kill", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            CogEntity.unsafeEntity(e).method_5768((class_3218)CogEntity.unsafeEntity(e).method_37908());
            e.e.clear();
            return null;
        });
        manager.reg("hasTag", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            return CogBool.getInstance(CogEntity.unsafeEntity(e).method_5752().contains(args.getString(0)));
        });
        manager.reg("addTag", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            return CogBool.getInstance(CogEntity.unsafeEntity(e).method_5780(args.getString(0)));
        });
        manager.reg("removeTag", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            return CogBool.getInstance(CogEntity.unsafeEntity(e).method_5738(args.getString(0)));
        });
        manager.reg("getTags", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            return CogArray.convertInstance(CogEntity.unsafeEntity(e).method_5752());
        });
        manager.reg("putInt", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            DataStorage.setInt(CogEntity.unsafeEntity(e), args.getString(0), args.requireInt(1));
            return e;
        });
        manager.reg("getInt", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            return new CogInteger(DataStorage.getInt(CogEntity.unsafeEntity(e), args.getString(0), 0));
        });
        manager.reg("putString", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            DataStorage.setString(CogEntity.unsafeEntity(e), args.getString(0), args.getString(1));
            return e;
        });
        manager.reg("getString", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            return new CogString(DataStorage.getString(CogEntity.unsafeEntity(e), args.getString(0), ""));
        });
        manager.reg("putBoolean", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            DataStorage.setBoolean(CogEntity.unsafeEntity(e), args.getString(0), args.requireBoolean(1));
            return e;
        });
        manager.reg("getBoolean", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            return CogBool.getInstance(DataStorage.getBoolean(CogEntity.unsafeEntity(e), args.getString(0), false));
        });
        manager.reg("putLong", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            DataStorage.setString(CogEntity.unsafeEntity(e), args.getString(0), String.valueOf(args.requireLong(1)));
            return e;
        });
        manager.reg("getLong", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            return new CogLong(DataStorage.getString(CogEntity.unsafeEntity(e), args.getString(0), "0"));
        });
        manager.reg("getDisplayName", (name, args, script, o) -> {
            CogEntity e = (CogEntity)o;
            return new CogString(Objects.requireNonNull(Objects.requireNonNull((class_1297)e.e.get(), "entity got unloaded"), "entity got unloaded").method_5476().getString());
        });
    }

    @NotNull
    private static class_1297 unsafeEntity(CogEntity e) {
        return Objects.requireNonNull((class_1297)e.e.get(), "entity got unloaded");
    }

    @Api.Experimental(since="2.0.0")
    public CogEntity(WeakReference<class_1297> entity) {
        this.e = entity;
    }

    @Api.Stable(since="2.0.0")
    public CogEntity(class_1297 entity) {
        this(new WeakReference<class_1297>(entity));
    }

    @Override
    public boolean hasOwnProperty(String name) {
        return MANAGER.hasOwnProperty(name);
    }

    @Override
    @Nullable
    public CGPM getProperty(String name, ArgumentData args, DispatchedScript script) {
        return MANAGER.get(name).handle(name, args, script, this);
    }

    @Override
    public boolean equalsTo(CGPM o) {
        if (o instanceof CogEntity) {
            CogEntity other = (CogEntity)o;
            return this.e.get() == other.e.get();
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.e);
    }
}

