/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.infrastructure.cog;

import com.storyanvil.cogwheel.api.Api;
import com.storyanvil.cogwheel.infrastructure.ArgumentData;
import com.storyanvil.cogwheel.infrastructure.CGPM;
import com.storyanvil.cogwheel.infrastructure.cog.CogBool;
import com.storyanvil.cogwheel.infrastructure.cog.CogDouble;
import com.storyanvil.cogwheel.infrastructure.cog.CogPrimalType;
import com.storyanvil.cogwheel.infrastructure.script.DispatchedScript;
import com.storyanvil.cogwheel.util.EasyPropManager;
import java.util.Objects;
import net.minecraft.class_2487;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CogInteger
implements CGPM,
CogPrimalType {
    private static final EasyPropManager MANAGER = new EasyPropManager("int", CogInteger::registerProps);
    private int value;

    private static void registerProps(@NotNull EasyPropManager manager) {
        manager.reg("add", (name, args, script, o) -> {
            CogInteger i = (CogInteger)o;
            i.value += args.requireInt(0);
            return i;
        });
        manager.reg("subtract", (name, args, script, o) -> {
            CogInteger i = (CogInteger)o;
            i.value -= args.requireInt(0);
            return i;
        });
        manager.reg("multiply", (name, args, script, o) -> {
            CogInteger i = (CogInteger)o;
            i.value *= args.requireInt(0);
            return i;
        });
        manager.reg("divide", (name, args, script, o) -> {
            CogInteger i = (CogInteger)o;
            i.value /= args.requireInt(0);
            return i;
        });
        manager.reg("clamp", (name, args, script, o) -> {
            CogInteger i = (CogInteger)o;
            int min = args.requireInt(0);
            int max = args.requireInt(1);
            if (i.value < min) {
                i.value = min;
            }
            if (i.value > max) {
                i.value = max;
            }
            return i;
        });
        manager.reg("abs", (name, args, script, o) -> {
            CogInteger i = (CogInteger)o;
            i.value = Math.abs(i.value);
            return i;
        });
        manager.reg("toDouble", (name, args, script, o) -> {
            CogInteger i = (CogInteger)o;
            return new CogDouble(i.value);
        });
        manager.reg("clone", (name, args, script, o) -> {
            CogInteger str = (CogInteger)o;
            return new CogInteger(str.value);
        });
        manager.reg("smaller", (name, args, script, o) -> {
            CogInteger str = (CogInteger)o;
            return CogBool.getInstance(str.value < args.requireInt(0));
        });
        manager.reg("bigger", (name, args, script, o) -> {
            CogInteger str = (CogInteger)o;
            return CogBool.getInstance(str.value > args.requireInt(0));
        });
    }

    @Contract(pure=true)
    @Api.Stable(since="2.0.0")
    public CogInteger(int value) {
        this.value = value;
    }

    @Api.Stable(since="2.0.0")
    public CogInteger(String value) {
        try {
            this.value = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            this.value = Math.toIntExact(Math.round(Double.parseDouble(value)));
        }
    }

    @Override
    public boolean hasOwnProperty(String name) {
        return MANAGER.hasOwnProperty(name);
    }

    @Override
    @Nullable
    public CGPM getProperty(String name, ArgumentData args, DispatchedScript script) {
        return MANAGER.get(name).handle(name, args, script, this);
    }

    @Contract(pure=true)
    public int getValue() {
        return this.value;
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public String convertToString() {
        return String.valueOf(this.value);
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    @Override
    @Contract(pure=true)
    public byte getPrimalID() {
        return 39;
    }

    @Override
    public void putPrimal(@NotNull class_2487 tag, String key) {
        tag.method_10569(key, this.value);
    }

    @Override
    public Object getObjValue() {
        return this.value;
    }
}

