/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.infrastructure.cog;

import com.storyanvil.cogwheel.api.Api;
import com.storyanvil.cogwheel.infrastructure.ArgumentData;
import com.storyanvil.cogwheel.infrastructure.CGPM;
import com.storyanvil.cogwheel.infrastructure.cog.CogInteger;
import com.storyanvil.cogwheel.infrastructure.cog.CogPrimalType;
import com.storyanvil.cogwheel.infrastructure.script.DispatchedScript;
import com.storyanvil.cogwheel.util.EasyPropManager;
import java.util.Objects;
import net.minecraft.class_2487;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CogString
implements CGPM,
CogPrimalType {
    private static final EasyPropManager MANAGER = new EasyPropManager("string", CogString::registerProps);
    private String value;

    public CogString(char c) {
        this(String.valueOf(c));
    }

    private static void registerProps(@NotNull EasyPropManager manager) {
        manager.reg("append", (name, args, script, o) -> {
            CogString str = (CogString)o;
            for (int i = 0; i < args.size(); ++i) {
                str.value = str.value + args.getString(i);
            }
            return str;
        });
        manager.reg("format", (name, args, script, o) -> {
            CogString str = (CogString)o;
            for (int i = 0; i < args.size(); ++i) {
                str.value = str.value.replaceFirst("\\{}", args.getString(i));
            }
            return str;
        });
        manager.reg("toUpperCase", (name, args, script, o) -> {
            CogString str = (CogString)o;
            str.value = str.value.toUpperCase();
            return str;
        });
        manager.reg("toLowerCase", (name, args, script, o) -> {
            CogString str = (CogString)o;
            str.value = str.value.toLowerCase();
            return str;
        });
        manager.reg("charAt", (name, args, script, o) -> {
            CogString str = (CogString)o;
            return new CogString(str.value.charAt(args.requireInt(0)));
        });
        manager.reg("substring", (name, args, script, o) -> {
            CogString str = (CogString)o;
            if (args.size() == 1) {
                return new CogString(str.value.substring(args.requireInt(0)));
            }
            return new CogString(str.value.substring(args.requireInt(0), args.requireInt(1)));
        });
        manager.reg("replace", (name, args, script, o) -> {
            CogString str = (CogString)o;
            str.value = str.value.replace(args.getString(0), args.getString(1));
            return str;
        });
        manager.reg("indexOf", (name, args, script, o) -> {
            CogString str = (CogString)o;
            return new CogInteger(str.value.indexOf(args.getString(0)));
        });
        manager.reg("clone", (name, args, script, o) -> {
            CogString str = (CogString)o;
            return new CogString(str.value);
        });
    }

    @Contract(pure=true)
    @Api.Stable(since="2.0.0")
    public CogString(String value) {
        this.value = value;
    }

    @Override
    public boolean hasOwnProperty(String name) {
        return MANAGER.hasOwnProperty(name);
    }

    @Override
    @Nullable
    public CGPM getProperty(String name, ArgumentData args, DispatchedScript script) {
        return MANAGER.get(name).handle(name, args, script, this);
    }

    @Contract(pure=true)
    public String getValue() {
        return this.value;
    }

    @Override
    @Contract(value="null -> false", pure=true)
    public boolean equalsTo(CGPM o) {
        if (o instanceof CogString) {
            CogString other = (CogString)o;
            return other.value.equals(this.value);
        }
        return false;
    }

    @Override
    @Contract(pure=true)
    public String convertToString() {
        return this.value;
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    @Override
    @Contract(pure=true)
    public byte getPrimalID() {
        return 41;
    }

    @Override
    public void putPrimal(@NotNull class_2487 tag, String key) {
        tag.method_10582(key, this.value);
    }

    @Override
    public Object getObjValue() {
        return this.value;
    }
}

