/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.infrastructure.cog;

import com.storyanvil.cogwheel.CogwheelExecutor;
import com.storyanvil.cogwheel.CogwheelHooks;
import com.storyanvil.cogwheel.infrastructure.ArgumentData;
import com.storyanvil.cogwheel.infrastructure.CGPM;
import com.storyanvil.cogwheel.infrastructure.StoryAction;
import com.storyanvil.cogwheel.infrastructure.abilities.StoryActionQueue;
import com.storyanvil.cogwheel.infrastructure.abilities.StoryChatter;
import com.storyanvil.cogwheel.infrastructure.cog.CogArray;
import com.storyanvil.cogwheel.infrastructure.cog.CogPlayer;
import com.storyanvil.cogwheel.infrastructure.cog.PreventSubCalling;
import com.storyanvil.cogwheel.infrastructure.cog.SubCallPostPrevention;
import com.storyanvil.cogwheel.infrastructure.script.DispatchedScript;
import com.storyanvil.cogwheel.util.EasyPropManager;
import com.storyanvil.cogwheel.util.ObjectMonitor;
import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Queue;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StoryLevel
implements StoryActionQueue<StoryLevel>,
StoryChatter,
ObjectMonitor.IMonitored {
    private static final ObjectMonitor<StoryLevel> MONITOR = new ObjectMonitor();
    private final Queue<StoryAction<? extends StoryLevel>> actionQueue = new ArrayDeque<StoryAction<? extends StoryLevel>>();
    private StoryAction current;
    private class_3218 world;
    private static final EasyPropManager MANAGER = new EasyPropManager("level", StoryLevel::registerProps);

    @Override
    public <R> void addStoryAction(StoryAction<R> action) {
        this.actionQueue.add(action);
    }

    @Override
    public void chat(String text) {
        class_5250 c = class_2561.method_43470((String)text);
        for (class_3222 player : this.world.method_18456()) {
            player.method_64398((class_2561)c);
        }
    }

    public void tick(class_3218 level) {
        this.world = level;
        if (this.current != null) {
            if (this.current.freeToGo(this)) {
                this.current = null;
            }
        } else {
            if (this.actionQueue.isEmpty()) {
                return;
            }
            this.current = this.actionQueue.remove();
            this.current.proceed(this);
        }
    }

    public StoryLevel() {
        MONITOR.register(this);
    }

    @Override
    public void reportState(StringBuilder sb) {
        for (StoryAction storyAction : this.actionQueue) {
            sb.append(storyAction.toString());
        }
        if (this.current != null) {
            sb.append(">").append(this.current);
        }
        if (this.world != null) {
            sb.append(" | ").append(this.world);
        }
    }

    private static void registerProps(@NotNull EasyPropManager manager) {
        manager.reg("runCommandWithAction", (name, args, script, o) -> {
            StoryLevel sl = (StoryLevel)o;
            return sl.addChained(new StoryAction.Instant<StoryLevel>(){

                @Override
                public void proceed(StoryLevel myself) {
                    CogwheelHooks.executeCommand(args.getString(0));
                }
            });
        });
        manager.reg("runCommand", (name, args, script, o) -> {
            CogwheelHooks.executeCommand(args.getString(0));
            return null;
        });
        manager.reg("getPlayers", (name, args, script, o) -> {
            throw new PreventSubCalling(new SubCallPostPrevention(){

                @Override
                public void prevent(String variable) {
                    CogwheelExecutor.scheduleTickEvent(world -> {
                        ArrayList<CogPlayer> players = new ArrayList<CogPlayer>();
                        for (class_3222 player : world.method_18456()) {
                            players.add(new CogPlayer(new WeakReference<class_3222>(player)));
                        }
                        script.put(variable, CogArray.getInstance(players));
                        CogwheelExecutor.schedule(script::lineDispatcher);
                    });
                }
            });
        });
        manager.reg("put", (name, args, script, o) -> {
            CogwheelHooks.putLevelData(args.getString(0), args.requirePrimal(1));
            return null;
        });
        manager.reg("get", (name, args, script, o) -> CogwheelHooks.getLevelData(args.getString(0)));
    }

    @Override
    public boolean hasOwnProperty(String name) {
        return MANAGER.hasOwnProperty(name);
    }

    @Override
    @Nullable
    public CGPM getProperty(String name, ArgumentData args, DispatchedScript script) {
        return MANAGER.get(name).handle(name, args, script, this);
    }

    @Override
    public boolean equalsTo(CGPM o) {
        return o == this;
    }

    public class_3218 getWorld() {
        return this.world;
    }
}

