/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.infrastructure.env;

import com.storyanvil.cogwheel.CogwheelExecutor;
import com.storyanvil.cogwheel.CogwheelHooks;
import com.storyanvil.cogwheel.api.Api;
import com.storyanvil.cogwheel.infrastructure.env.LibraryEnvironment;
import com.storyanvil.cogwheel.infrastructure.script.DispatchedScript;
import com.storyanvil.cogwheel.registry.CogwheelRegistries;
import com.storyanvil.cogwheel.util.ScriptStorage;
import com.storyanvil.cogwheel.util.WeakList;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;

public abstract class CogScriptEnvironment {
    private final HashMap<class_2960, List<String>> eventSubscribers = new HashMap();
    private final long creationTime = System.currentTimeMillis();

    @Contract(pure=true)
    public CogScriptEnvironment() {
    }

    @Api.Stable(since="2.0.0")
    public static LibraryEnvironment getLibEnvironment(String string) {
        return CogwheelExecutor.getLibraryEnvironment(string);
    }

    @Api.Stable(since="2.0.0")
    public void dispatchEvent(class_2960 event, ScriptStorage storage) {
        if (this.eventSubscribers.containsKey(event)) {
            List<String> subscribedScripts = this.eventSubscribers.get(event);
            for (String script : subscribedScripts) {
                this.dispatchScript(script, storage);
            }
        }
    }

    @Api.Stable(since="2.0.0")
    public void subscribeForEvent(class_2960 event, String scriptName) {
        if (!this.eventSubscribers.containsKey(event)) {
            this.eventSubscribers.put(event, new ArrayList());
        }
        this.eventSubscribers.get(event).add(scriptName);
    }

    @Api.Stable(since="2.0.0")
    public void unsubscribeFromEvent(class_2960 event, String scriptName) {
        if (!this.eventSubscribers.containsKey(event)) {
            this.eventSubscribers.put(event, new ArrayList());
            return;
        }
        this.eventSubscribers.get(event).remove(scriptName);
    }

    @Api.Stable(since="2.0.0")
    public void unsubscribeAllFromEvent(class_2960 event) {
        this.eventSubscribers.remove(event);
    }

    @Api.Stable(since="2.0.0")
    public static void dispatchEventGlobal(class_2960 event, ScriptStorage storage) {
        CogwheelExecutor.getDefaultEnvironment().dispatchEvent(event, storage);
        for (CogScriptEnvironment cogScriptEnvironment : CogwheelExecutor.getLibraryEnvironments()) {
            cogScriptEnvironment.dispatchEvent(event, storage);
        }
    }

    @ApiStatus.Internal
    public void dispose() {
        CogwheelExecutor.log.info("Environment {} is disposing...", (Object)this.getUniqueIdentifier());
        WeakList<DispatchedScript> scripts = DispatchedScript.MONITOR.getObjects();
        if (scripts == null) {
            return;
        }
        for (int i = 0; i < scripts.size(); ++i) {
            DispatchedScript script = scripts.get(i);
            if (script == null) {
                scripts.remove(i);
                --i;
                continue;
            }
            if (script.getEnvironment() != this) continue;
            script.haltExecution();
        }
    }

    public boolean canBeEdited() {
        return false;
    }

    public abstract void dispatchScript(String var1);

    public abstract void dispatchScript(String var1, ScriptStorage var2);

    public abstract String getScript(String var1);

    public void defaultVariablesFactory(ScriptStorage storage, DispatchedScript script) {
        CogwheelRegistries.putDefaults(storage, script);
    }

    @Api.Internal
    @ApiStatus.Internal
    public static void dispatchScriptGlobal(String rl) {
        class_2960 loc = class_2960.method_12829((String)rl);
        CogScriptEnvironment.dispatchScriptGlobal(loc);
    }

    @Api.Experimental(since="2.0.0")
    public static void dispatchScriptGlobal(class_2960 loc) {
        CogScriptEnvironment environment = null;
        environment = CogScriptEnvironment.getEnvironment(loc);
        if (environment == null) {
            throw new RuntimeException("Dispatch Failure! No environment found");
        }
        environment.dispatchScript(loc.method_12832());
    }

    public static CogScriptEnvironment getEnvironment(class_2960 loc) {
        CogScriptEnvironment environment = loc.method_12836().equals("def") || loc.method_12836().equals("minecraft") ? CogwheelExecutor.getDefaultEnvironment() : (loc.method_12836().equals("wrld") ? CogwheelExecutor.getWorldEnvironment() : CogwheelExecutor.getLibraryEnvironment(loc.method_12836()));
        return environment;
    }

    @Api.Internal
    @ApiStatus.Internal
    public static void dispatchScriptGlobal(String rl, ScriptStorage storage) {
        class_2960 loc = class_2960.method_12829((String)rl);
        CogScriptEnvironment.dispatchScriptGlobal(loc, storage);
    }

    @Api.Experimental(since="2.0.0")
    public static void dispatchScriptGlobal(class_2960 loc, ScriptStorage storage) {
        CogScriptEnvironment environment = CogScriptEnvironment.getEnvironment(loc);
        if (environment == null) {
            throw new RuntimeException("Dispatch Failure! No environment found");
        }
        environment.dispatchScript(loc.method_12832(), storage);
    }

    @Api.Internal
    @ApiStatus.Internal
    public static File getScriptFile(class_2960 rl) {
        CogScriptEnvironment environment = CogScriptEnvironment.getEnvironment(rl);
        return new File(CogwheelHooks.getConfigFolder(), environment.getScript(rl.method_12832()));
    }

    public abstract String getUniqueIdentifier();

    public long getCreationTime() {
        return this.creationTime;
    }

    public String toString() {
        return "CogScriptEnvironment{name=" + this.getUniqueIdentifier() + "}";
    }
}

