/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.infrastructure.env;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.storyanvil.cogwheel.CogwheelExecutor;
import com.storyanvil.cogwheel.infrastructure.CogScriptDispatcher;
import com.storyanvil.cogwheel.infrastructure.env.CogScriptEnvironment;
import com.storyanvil.cogwheel.util.ScriptStorage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import org.jetbrains.annotations.ApiStatus;

public class LibraryEnvironment
extends CogScriptEnvironment {
    private final String name;

    public LibraryEnvironment(String name) {
        this.name = name;
        CogwheelExecutor.log.info("Library Environment {} initialized!", (Object)this.getUniqueIdentifier());
    }

    @ApiStatus.Internal
    public boolean init(File dotCog) {
        try {
            File manifest = new File(dotCog, "manifest.json");
            JsonObject obj = JsonParser.parseReader((Reader)new FileReader(manifest)).getAsJsonObject();
            String name = obj.get("name").getAsJsonPrimitive().getAsString();
            if (!name.equals(this.name)) {
                throw new IllegalStateException("Library names does not match!");
            }
        }
        catch (FileNotFoundException | IllegalStateException e) {
            CogwheelExecutor.log.info("Library \"{}\" does not have manifest.json or its manifest.json is invalid. Library won't be loaded", (Object)this.name);
            CogwheelExecutor.log.info("Exception for {}", (Object)this.name, (Object)e);
            return false;
        }
        return true;
    }

    @Override
    public void dispatchScript(String name) {
        CogScriptDispatcher.dispatch("cog-libs/.cog/" + this.name + "/" + name, this);
    }

    @Override
    public void dispatchScript(String name, ScriptStorage storage) {
        CogScriptDispatcher.dispatch("cog-libs/.cog/" + this.name + "/" + name, storage, (CogScriptEnvironment)this);
    }

    @Override
    public String getScript(String name) {
        return "cog-libs/.cog/" + this.name + "/" + name;
    }

    @Override
    public String getUniqueIdentifier() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }
}

