/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.infrastructure.script;

import com.storyanvil.cogwheel.CogwheelExecutor;
import com.storyanvil.cogwheel.api.Api;
import com.storyanvil.cogwheel.infrastructure.CGPM;
import com.storyanvil.cogwheel.infrastructure.env.CogScriptEnvironment;
import com.storyanvil.cogwheel.infrastructure.script.DispatchedScript;
import com.storyanvil.cogwheel.registry.CogwheelRegistries;
import com.storyanvil.cogwheel.util.ScriptStorage;
import java.util.ArrayList;

public class StreamExecutionScript
extends DispatchedScript {
    public StreamExecutionScript(ArrayList<String> linesToExecute, ScriptStorage storage, CogScriptEnvironment environment) {
        super(linesToExecute, storage, environment);
    }

    public StreamExecutionScript(ArrayList<String> linesToExecute, CogScriptEnvironment environment) {
        super(linesToExecute, environment);
    }

    public StreamExecutionScript(ScriptStorage storage, CogScriptEnvironment environment) {
        super(new ArrayList<String>(), storage, environment);
    }

    public StreamExecutionScript(CogScriptEnvironment environment) {
        super(new ArrayList<String>(), environment);
    }

    @Api.Stable(since="2.7.0")
    public boolean addLine(String line) {
        this.linesToExecute.add(line);
        return this.lineDispatcher();
    }

    @Api.Stable(since="2.7.0")
    public void addLineFrozen(String line) {
        this.linesToExecute.add(line);
    }

    @Api.Stable(since="2.7.0")
    public void addLineRedirecting(String line) {
        this.linesToExecute.add(line);
        CogwheelExecutor.schedule(this::lineDispatcher);
    }

    @Api.Stable(since="2.7.0")
    public CGPM fastExecute(String line) {
        return CogwheelRegistries.expressionHandler(line, this, false).getB();
    }
}

