/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.network.devui.editor;

import com.storyanvil.cogwheel.network.devui.CogwheelNetwork;
import com.storyanvil.cogwheel.network.devui.DevEditorState;
import com.storyanvil.cogwheel.network.devui.DevEditorUserDelta;
import com.storyanvil.cogwheel.network.devui.editor.DevEditorSession;
import java.lang.ref.WeakReference;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public class DevEditorUser {
    private DevEditorSession session;
    private WeakReference<class_3222> player;
    private int line = 0;
    private int pos = 0;
    private int selectedChars = 0;
    private int color = 0;

    public DevEditorUser(DevEditorSession session, @NotNull class_3222 player) {
        if (player == null) {
            throw new IllegalStateException("Player is null");
        }
        this.session = session;
        this.player = new WeakReference<class_3222>(player);
    }

    public boolean isInvalid() {
        return this.player.refersTo(null);
    }

    public void dispose() {
        class_3222 plr = (class_3222)this.player.get();
        if (plr != null) {
            CogwheelNetwork.sendFromServer(plr, new DevEditorState(this.session.lc, (byte)-128));
            plr = null;
        }
        this.session = null;
        this.player.clear();
        this.player = null;
    }

    public boolean refersTo(class_3222 plr) {
        return this.player.refersTo(plr);
    }

    public class_3222 get() {
        return (class_3222)this.player.get();
    }

    public DevEditorUserDelta toDelta() {
        return new DevEditorUserDelta(this.session.lc, this.line, this.pos, this.selectedChars, ((class_3222)this.player.get()).method_5820(), this.color);
    }

    public void applyDelta(DevEditorUserDelta delta) {
        this.pos = delta.pos();
        this.line = delta.line();
        this.selectedChars = delta.selected();
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        if (line < 0) {
            this.line = 0;
            return;
        }
        this.line = line;
    }

    public int getPos() {
        return this.pos;
    }

    public void setPos(int pos) {
        if (pos <= 0) {
            this.pos = 0;
            return;
        }
        this.pos = pos;
    }

    public int getSelectedChars() {
        return this.selectedChars;
    }

    public void setSelectedChars(int selectedChars) {
        this.selectedChars = selectedChars;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }
}

