/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.storyanvil.cogwheel.api.Api;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.minecraft.class_2481;
import net.minecraft.class_2483;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2497;
import net.minecraft.class_2503;
import net.minecraft.class_2514;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StoryUtils {
    @Api.Stable(since="2.0.0")
    public static void sendGlobalMessage(@NotNull class_3218 level, class_2561 msg) {
        for (class_3222 player : level.method_18456()) {
            player.method_64398(msg);
        }
    }

    @Api.Stable(since="2.0.0")
    public static void sendGlobalMessage(@NotNull class_3218 level, class_2561 ... msg) {
        for (class_3222 player : level.method_18456()) {
            for (class_2561 c : msg) {
                player.method_64398(c);
            }
        }
    }

    @Api.Stable(since="2.0.0")
    public static void deleteDirectory(@NotNull File dir) {
        File[] childFiles;
        if (!dir.exists()) {
            return;
        }
        if (dir.isDirectory() && (childFiles = dir.listFiles()) != null) {
            for (File f : childFiles) {
                StoryUtils.deleteDirectory(f);
            }
        }
        if (!dir.delete()) {
            throw new RuntimeException("Failed to delete: " + String.valueOf(dir));
        }
    }

    public static void discoverDirectory(@NotNull File file, @NotNull BiConsumer<File, String> consumer) {
        StoryUtils.discoverDirectory(file, consumer, "");
    }

    public static void discoverDirectory(@NotNull File file, @NotNull BiConsumer<File, String> consumer, @NotNull String path) {
        path = (String)path + "/" + file.getName();
        if (!file.isDirectory()) {
            consumer.accept(file, (String)path);
            return;
        }
        File[] files = file.listFiles();
        if (files == null) {
            return;
        }
        for (File f : files) {
            StoryUtils.discoverDirectory(f, consumer, (String)path);
        }
    }

    @Api.Experimental(since="2.0.0")
    public static void unpackZip(File zip, File directory) throws IOException {
        byte[] buffer = new byte[1024];
        ZipInputStream zis = new ZipInputStream(new FileInputStream(zip));
        ZipEntry zipEntry = zis.getNextEntry();
        while (zipEntry != null) {
            File newFile = StoryUtils.newFile(directory, zipEntry);
            if (zipEntry.isDirectory()) {
                if (!newFile.isDirectory() && !newFile.mkdirs()) {
                    throw new IOException("Failed to create directory " + String.valueOf(newFile));
                }
            } else {
                int len;
                File parent = newFile.getParentFile();
                if (!parent.isDirectory() && !parent.mkdirs()) {
                    throw new IOException("Failed to create directory " + String.valueOf(parent));
                }
                FileOutputStream fos = new FileOutputStream(newFile);
                while ((len = zis.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
                fos.close();
            }
            zipEntry = zis.getNextEntry();
        }
        zis.closeEntry();
        zis.close();
    }

    @NotNull
    private static File newFile(File destinationDir, @NotNull ZipEntry zipEntry) throws IOException {
        File destFile = new File(destinationDir, zipEntry.getName());
        String destDirPath = destinationDir.getCanonicalPath();
        String destFilePath = destFile.getCanonicalPath();
        if (!destFilePath.startsWith(destDirPath + File.separator)) {
            throw new IOException("Entry is outside of the target dir: " + zipEntry.getName());
        }
        return destFile;
    }

    @Api.Stable(since="2.6.0")
    public static boolean isHovering(int mouseX, int mouseY, int left, int right, int top, int bottom) {
        return mouseX >= left && mouseX <= right && mouseY >= top && mouseY <= bottom;
    }

    @Api.Stable(since="2.9.0")
    public static class_5250 subText(class_5250 source, int from, int to) {
        class_5250 c = class_2561.method_43473();
        boolean l = false;
        AtomicInteger skip = new AtomicInteger(from);
        AtomicInteger left = new AtomicInteger(to - from - 1);
        source.method_27658((style, content) -> {
            int s = content.length();
            if (skip.get() > 0) {
                if (skip.get() >= s) {
                    skip.addAndGet(-s);
                } else {
                    c.method_10852((class_2561)class_2561.method_43470((String)content.substring(skip.get())).method_27696(style));
                    skip.set(0);
                }
                return Optional.empty();
            }
            if (left.get() > 0) {
                int lef = left.get();
                if (lef > s) {
                    c.method_10852((class_2561)class_2561.method_43470((String)content).method_27696(style));
                    left.addAndGet(-s);
                } else {
                    c.method_10852((class_2561)class_2561.method_43470((String)content.substring(0, lef)).method_27696(style));
                    left.set(0);
                }
            }
            return Optional.empty();
        }, class_2583.field_24360);
        return c;
    }

    @Api.Stable(since="2.10.1")
    public static JsonObject toCompoundJSON(class_2487 tag) {
        JsonObject root = new JsonObject();
        for (String key : tag.method_10541()) {
            class_2520 t = tag.method_10580(key);
            JsonElement e = StoryUtils.toElement(t);
            if (e == null) continue;
            root.add(key, e);
        }
        return root;
    }

    @Api.Stable(since="2.10.1")
    public static JsonArray toCompoundJSON(class_2483<?> tag) {
        JsonArray root = new JsonArray();
        for (int i = 0; i < root.size(); ++i) {
            JsonElement e = StoryUtils.toElement((class_2520)tag.get(i));
            if (e == null) continue;
            root.add(e);
        }
        return root;
    }

    @Api.Stable(since="2.10.1")
    public static JsonElement toElement(class_2520 t) {
        if (t instanceof class_2514) {
            if (t instanceof class_2516) {
                class_2516 T = (class_2516)t;
                return StoryUtils.toJSON(T);
            }
            if (t instanceof class_2489) {
                class_2489 T = (class_2489)t;
                return StoryUtils.toJSON(T);
            }
            if (t instanceof class_2494) {
                class_2494 T = (class_2494)t;
                return StoryUtils.toJSON(T);
            }
            if (t instanceof class_2481) {
                class_2481 T = (class_2481)t;
                return StoryUtils.toJSON(T);
            }
            if (t instanceof class_2497) {
                class_2497 T = (class_2497)t;
                return StoryUtils.toJSON(T);
            }
            if (t instanceof class_2503) {
                class_2503 T = (class_2503)t;
                return StoryUtils.toJSON(T);
            }
        } else {
            if (t instanceof class_2487) {
                class_2487 T = (class_2487)t;
                return StoryUtils.toCompoundJSON(T);
            }
            if (t instanceof class_2483) {
                class_2483 T = (class_2483)t;
                return StoryUtils.toCompoundJSON(T);
            }
            if (t instanceof class_2519) {
                class_2519 T = (class_2519)t;
                return StoryUtils.toJSON(T);
            }
        }
        return null;
    }

    @Api.Stable(since="2.10.1")
    public static JsonPrimitive toJSON(class_2519 tag) {
        return new JsonPrimitive(tag.method_10714());
    }

    @Api.Stable(since="2.10.1")
    public static JsonPrimitive toJSON(class_2516 tag) {
        return new JsonPrimitive((Number)tag.method_10696());
    }

    @Api.Stable(since="2.10.1")
    public static JsonPrimitive toJSON(class_2489 tag) {
        return new JsonPrimitive((Number)tag.method_10697());
    }

    @Api.Stable(since="2.10.1")
    public static JsonPrimitive toJSON(class_2494 tag) {
        return new JsonPrimitive((Number)Float.valueOf(tag.method_10700()));
    }

    @Api.Stable(since="2.10.1")
    public static JsonPrimitive toJSON(class_2481 tag) {
        return new JsonPrimitive((Number)tag.method_10698());
    }

    @Api.Stable(since="2.10.1")
    public static JsonPrimitive toJSON(class_2497 tag) {
        return new JsonPrimitive((Number)tag.method_10701());
    }

    @Api.Stable(since="2.10.1")
    public static JsonPrimitive toJSON(class_2503 tag) {
        return new JsonPrimitive((Number)tag.method_10699());
    }

    @Api.Stable(since="2.0.0")
    public static void encodeString(@NotNull class_2540 buf, @Nullable String str) {
        if (str == null) {
            str = "";
        }
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        buf.method_53002(bytes.length);
        buf.method_52983(bytes);
    }

    @Contract(value="_ -> new")
    @Api.Stable(since="2.0.0")
    @NotNull
    public static String decodeString(@NotNull class_2540 buf) {
        int length = buf.readInt();
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = buf.readByte();
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }
}

