/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.util;

import com.storyanvil.cogwheel.api.Api;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class StoryUtils {
    @Api.Stable(since="2.0.0")
    public static void sendGlobalMessage(@NotNull ServerLevel level, Component msg) {
        for (ServerPlayer player : level.m_6907_()) {
            player.m_213846_(msg);
        }
    }

    @Api.Stable(since="2.0.0")
    public static void sendGlobalMessage(@NotNull ServerLevel level, Component ... msg) {
        for (ServerPlayer player : level.m_6907_()) {
            for (Component c : msg) {
                player.m_213846_(c);
            }
        }
    }

    @Api.Stable(since="2.0.0")
    public static void encodeString(@NotNull FriendlyByteBuf buf, @NotNull String str) {
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        buf.writeInt(bytes.length);
        buf.writeBytes(bytes);
    }

    @Contract(value="_ -> new")
    @Api.Stable(since="2.0.0")
    @NotNull
    public static String decodeString(@NotNull FriendlyByteBuf buf) {
        int length = buf.readInt();
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = buf.readByte();
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    @Api.Stable(since="2.0.0")
    public static void deleteDirectory(@NotNull File dir) {
        File[] childFiles;
        if (!dir.exists()) {
            return;
        }
        if (dir.isDirectory() && (childFiles = dir.listFiles()) != null) {
            for (File f : childFiles) {
                StoryUtils.deleteDirectory(f);
            }
        }
        if (!dir.delete()) {
            throw new RuntimeException("Failed to delete: " + String.valueOf(dir));
        }
    }

    @Api.Experimental(since="2.0.0")
    public static void unpackZip(File zip, File directory) throws IOException {
        byte[] buffer = new byte[1024];
        ZipInputStream zis = new ZipInputStream(new FileInputStream(zip));
        ZipEntry zipEntry = zis.getNextEntry();
        while (zipEntry != null) {
            File newFile = StoryUtils.newFile(directory, zipEntry);
            if (zipEntry.isDirectory()) {
                if (!newFile.isDirectory() && !newFile.mkdirs()) {
                    throw new IOException("Failed to create directory " + String.valueOf(newFile));
                }
            } else {
                int len;
                File parent = newFile.getParentFile();
                if (!parent.isDirectory() && !parent.mkdirs()) {
                    throw new IOException("Failed to create directory " + String.valueOf(parent));
                }
                FileOutputStream fos = new FileOutputStream(newFile);
                while ((len = zis.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
                fos.close();
            }
            zipEntry = zis.getNextEntry();
        }
        zis.closeEntry();
        zis.close();
    }

    @NotNull
    private static File newFile(File destinationDir, @NotNull ZipEntry zipEntry) throws IOException {
        File destFile = new File(destinationDir, zipEntry.getName());
        String destDirPath = destinationDir.getCanonicalPath();
        String destFilePath = destFile.getCanonicalPath();
        if (!destFilePath.startsWith(destDirPath + File.separator)) {
            throw new IOException("Entry is outside of the target dir: " + zipEntry.getName());
        }
        return destFile;
    }
}

