/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel;

import com.storyanvil.cogwheel.EventBus;
import com.storyanvil.cogwheel.api.Api;
import com.storyanvil.cogwheel.infrastructure.env.CogScriptEnvironment;
import com.storyanvil.cogwheel.util.Bi;
import com.storyanvil.cogwheel.util.StoryUtils;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod.EventBusSubscriber(modid="storyanvil_cogwheel")
public class CogwheelExecutor {
    @Api.Internal
    @ApiStatus.Internal
    public static final Logger log = LoggerFactory.getLogger((String)"STORYANVIL/COGWHEEL/EXECUTOR");
    private static final ScheduledThreadPoolExecutor poolExecutor = new ScheduledThreadPoolExecutor(2, (ThreadFactory)new DefaultThreadFactory("cogwheel-executor"));
    private static final ScheduledThreadPoolExecutor beltThread = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new DefaultThreadFactory("cogwheel-belt-protocol"));
    private static CogScriptEnvironment.DefaultEnvironment defaultEnvironment;
    private static HashMap<String, CogScriptEnvironment.LibraryEnvironment> libraryEnvironments;
    private static CogScriptEnvironment.WorldEnvironment worldEnvironment;

    @Api.Internal
    @ApiStatus.Internal
    protected static void init() {
        poolExecutor.setMaximumPoolSize(2);
        beltThread.setMaximumPoolSize(1);
    }

    @Api.Stable(since="2.0.0")
    public static void schedule(Runnable task) {
        poolExecutor.execute(task);
    }

    @Api.Stable(since="2.0.0")
    public static void schedule(Runnable task, int ms) {
        poolExecutor.schedule(task, (long)ms, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api.Stable(since="2.0.0")
    public static void scheduleTickEvent(Consumer<TickEvent.LevelTickEvent> task) {
        List<Bi<Consumer<TickEvent.LevelTickEvent>, Integer>> list = EventBus.queue;
        synchronized (list) {
            EventBus.queue.add(new Bi<Consumer<TickEvent.LevelTickEvent>, Integer>(task, 0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api.Stable(since="2.0.0")
    public static void scheduleTickEvent(Consumer<TickEvent.LevelTickEvent> task, int ticks) {
        List<Bi<Consumer<TickEvent.LevelTickEvent>, Integer>> list = EventBus.queue;
        synchronized (list) {
            EventBus.queue.add(new Bi<Consumer<TickEvent.LevelTickEvent>, Integer>(task, ticks));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api.Stable(since="2.0.0")
    public static void scheduleTickEventClientSide(Consumer<TickEvent.LevelTickEvent> task) {
        List<Bi<Consumer<TickEvent.LevelTickEvent>, Integer>> list = EventBus.clientQueue;
        synchronized (list) {
            EventBus.clientQueue.add(new Bi<Consumer<TickEvent.LevelTickEvent>, Integer>(task, 0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api.Stable(since="2.0.0")
    public static void scheduleTickEventClientSide(Consumer<TickEvent.LevelTickEvent> task, int ticks) {
        List<Bi<Consumer<TickEvent.LevelTickEvent>, Integer>> list = EventBus.clientQueue;
        synchronized (list) {
            EventBus.clientQueue.add(new Bi<Consumer<TickEvent.LevelTickEvent>, Integer>(task, ticks));
        }
    }

    @Api.Internal
    @ApiStatus.Internal
    public static void scheduleBelt(Runnable task) {
        beltThread.execute(task);
    }

    @Api.Internal
    @ApiStatus.Internal
    public static void scheduleBelt(Runnable task, int ms) {
        beltThread.schedule(task, (long)ms, TimeUnit.MILLISECONDS);
    }

    @SubscribeEvent
    @Api.Internal
    @ApiStatus.Internal
    public static void serverStart(ServerStartingEvent event) {
        log.info("Creating CogScript default environment...");
        defaultEnvironment = new CogScriptEnvironment.DefaultEnvironment();
        worldEnvironment = new CogScriptEnvironment.WorldEnvironment();
        if (libraryEnvironments != null) {
            libraryEnvironments.clear();
        }
        libraryEnvironments = new HashMap();
        File libs = new File(Minecraft.m_91087_().f_91069_, "config/cog-libs/");
        File scripts = new File(Minecraft.m_91087_().f_91069_, "config/cog/");
        File unpackedLibraries = new File(libs, ".cog");
        if (!libs.exists()) {
            libs.mkdir();
        }
        if (!scripts.exists()) {
            scripts.mkdir();
        }
        if (unpackedLibraries.exists()) {
            StoryUtils.deleteDirectory(unpackedLibraries);
        }
        unpackedLibraries.mkdir();
        File[] libFiles = libs.listFiles();
        ArrayList<String> libraryNames = new ArrayList<String>();
        if (libFiles != null) {
            for (File lib : libFiles) {
                String name = lib.getName();
                if (name.endsWith(".salc")) {
                    File unpacked = new File(unpackedLibraries, name);
                    if (!unpacked.mkdir()) {
                        throw new RuntimeException("Failed to create " + String.valueOf(unpacked));
                    }
                    try {
                        StoryUtils.unpackZip(lib, unpacked);
                        libraryNames.add(name);
                        continue;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to unpack " + String.valueOf(lib), e);
                    }
                }
                log.info("File {} is not StoryAnvil Locomotive Car (aka Cogwheel Engine library)", (Object)lib);
            }
        }
        for (String library : libraryNames) {
            CogScriptEnvironment.LibraryEnvironment environment = new CogScriptEnvironment.LibraryEnvironment(library);
            libraryEnvironments.put(library, environment);
        }
        log.info("Environments will be notified of initialization");
        defaultEnvironment.dispatchScript("init.sa");
        worldEnvironment.dispatchScript("init.sa");
        for (CogScriptEnvironment.LibraryEnvironment environment : libraryEnvironments.values()) {
            if (!environment.init(new File(unpackedLibraries, environment.getUniqueIdentifier()))) {
                libraryEnvironments.remove(environment.getUniqueIdentifier());
                environment.dispose();
            }
            environment.dispatchScript("init.sa");
        }
    }

    @SubscribeEvent
    @Api.Internal
    @ApiStatus.Internal
    public static void serverStop(ServerStoppingEvent event) {
        log.info("Disposing all CogScript environments...");
        defaultEnvironment.dispose();
        defaultEnvironment = null;
        worldEnvironment.dispose();
        worldEnvironment = null;
        for (CogScriptEnvironment.LibraryEnvironment environment : libraryEnvironments.values()) {
            environment.dispose();
        }
        libraryEnvironments = null;
    }

    @Api.Stable(since="2.0.0")
    public static CogScriptEnvironment.DefaultEnvironment getDefaultEnvironment() {
        return defaultEnvironment;
    }

    @Api.Stable(since="2.1.0")
    public static CogScriptEnvironment.WorldEnvironment getWorldEnvironment() {
        return worldEnvironment;
    }

    @Api.Stable(since="2.0.0")
    public static CogScriptEnvironment.LibraryEnvironment getLibraryEnvironment(String namespace) {
        return libraryEnvironments.get(namespace);
    }

    @Api.Experimental(since="2.0.0")
    public static Collection<CogScriptEnvironment.LibraryEnvironment> getLibraryEnvironments() {
        return libraryEnvironments.values();
    }
}

