/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel.infrastructure.cog;

import com.storyanvil.cogwheel.api.Api;
import com.storyanvil.cogwheel.infrastructure.ArgumentData;
import com.storyanvil.cogwheel.infrastructure.CogPropertyManager;
import com.storyanvil.cogwheel.infrastructure.DispatchedScript;
import com.storyanvil.cogwheel.infrastructure.cog.CogBool;
import com.storyanvil.cogwheel.infrastructure.cog.PreventSubCalling;
import com.storyanvil.cogwheel.util.EasyPropManager;
import com.storyanvil.cogwheel.util.ScriptStorage;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CogHashmap
implements CogPropertyManager {
    private static final EasyPropManager MANAGER = new EasyPropManager("hashmap", CogHashmap::registerProps);
    private final ScriptStorage value;

    @Contract(pure=true)
    @Api.Stable(since="2.0.0")
    public CogHashmap(ScriptStorage value) {
        this.value = value;
    }

    @Contract(pure=true)
    @Api.Stable(since="2.0.0")
    public CogHashmap() {
        this.value = new ScriptStorage();
    }

    public ScriptStorage getValue() {
        return this.value;
    }

    private static void registerProps(@NotNull EasyPropManager manager) {
        manager.reg("get", (name, args, script, o) -> {
            CogHashmap hashmap = (CogHashmap)o;
            return (CogPropertyManager)hashmap.value.get(args.get(0).convertToString());
        });
        manager.reg("put", (name, args, script, o) -> {
            CogHashmap hashmap = (CogHashmap)o;
            return hashmap.value.put(args.get(0).convertToString(), args.get(1));
        });
        manager.reg("clear", (name, args, script, o) -> {
            CogHashmap hashmap = (CogHashmap)o;
            hashmap.value.clear();
            return hashmap;
        });
        manager.reg("containsKey", (name, args, script, o) -> {
            CogHashmap hashmap = (CogHashmap)o;
            return CogBool.getInstance(hashmap.value.containsKey(args.get(0).convertToString()));
        });
    }

    @Override
    public boolean hasOwnProperty(String name) {
        return MANAGER.hasOwnProperty(name);
    }

    @Override
    @Nullable
    public CogPropertyManager getProperty(String name, ArgumentData args, DispatchedScript script) throws PreventSubCalling {
        return MANAGER.get(name).handle(name, args, script, this);
    }

    @Override
    public boolean equalsTo(CogPropertyManager o) {
        if (o instanceof CogHashmap) {
            CogHashmap other = (CogHashmap)o;
            return other.value.equals(this.value);
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

