/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.storyanvil.cogwheel.EventBus;
import com.storyanvil.cogwheel.api.Api;
import com.storyanvil.cogwheel.config.CogwheelConfig;
import com.storyanvil.cogwheel.infrastructure.env.CogScriptEnvironment;
import com.storyanvil.cogwheel.infrastructure.script.StreamExecutionScript;
import com.storyanvil.cogwheel.util.Bi;
import com.storyanvil.cogwheel.util.StoryUtils;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod.EventBusSubscriber(modid="storyanvil_cogwheel")
public class CogwheelExecutor {
    @Api.Internal
    @ApiStatus.Internal
    public static final Logger log = LoggerFactory.getLogger((String)"STORYANVIL/COGWHEEL/EXECUTOR");
    private static final ScheduledThreadPoolExecutor poolExecutor = new ScheduledThreadPoolExecutor(2, (ThreadFactory)new DefaultThreadFactory("cogwheel-executor"));
    private static final ScheduledThreadPoolExecutor beltThread = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new DefaultThreadFactory("cogwheel-belt-protocol"));
    private static CogScriptEnvironment.DefaultEnvironment defaultEnvironment;
    private static HashMap<String, CogScriptEnvironment.LibraryEnvironment> libraryEnvironments;
    private static CogScriptEnvironment.WorldEnvironment worldEnvironment;
    private static StreamExecutionScript chatConsole;

    @Api.Internal
    @ApiStatus.Internal
    protected static void init() {
        poolExecutor.setMaximumPoolSize(2);
        beltThread.setMaximumPoolSize(1);
    }

    @Api.Stable(since="2.0.0")
    public static void schedule(Runnable task) {
        poolExecutor.execute(task);
    }

    @Api.Stable(since="2.0.0")
    public static void schedule(Runnable task, int ms) {
        poolExecutor.schedule(task, (long)ms, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api.Stable(since="2.0.0")
    public static void scheduleTickEvent(Consumer<TickEvent.LevelTickEvent> task) {
        List<Bi<Consumer<TickEvent.LevelTickEvent>, Integer>> list = EventBus.queue;
        synchronized (list) {
            EventBus.queue.add(new Bi<Consumer<TickEvent.LevelTickEvent>, Integer>(task, 0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api.Stable(since="2.0.0")
    public static void scheduleTickEvent(Consumer<TickEvent.LevelTickEvent> task, int ticks) {
        List<Bi<Consumer<TickEvent.LevelTickEvent>, Integer>> list = EventBus.queue;
        synchronized (list) {
            EventBus.queue.add(new Bi<Consumer<TickEvent.LevelTickEvent>, Integer>(task, ticks));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api.Stable(since="2.0.0")
    public static void scheduleTickEventClientSide(Consumer<TickEvent.LevelTickEvent> task) {
        List<Bi<Consumer<TickEvent.LevelTickEvent>, Integer>> list = EventBus.clientQueue;
        synchronized (list) {
            EventBus.clientQueue.add(new Bi<Consumer<TickEvent.LevelTickEvent>, Integer>(task, 0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Api.Stable(since="2.0.0")
    public static void scheduleTickEventClientSide(Consumer<TickEvent.LevelTickEvent> task, int ticks) {
        List<Bi<Consumer<TickEvent.LevelTickEvent>, Integer>> list = EventBus.clientQueue;
        synchronized (list) {
            EventBus.clientQueue.add(new Bi<Consumer<TickEvent.LevelTickEvent>, Integer>(task, ticks));
        }
    }

    @Api.Internal
    @ApiStatus.Internal
    public static void scheduleBelt(Runnable task) {
        beltThread.execute(task);
    }

    @Api.Internal
    @ApiStatus.Internal
    public static void scheduleBelt(Runnable task, int ms) {
        beltThread.schedule(task, (long)ms, TimeUnit.MILLISECONDS);
    }

    @SubscribeEvent
    @Api.Internal
    @ApiStatus.Internal
    public static void serverStart(ServerStartingEvent event) {
        log.info("Creating CogScript default environments...");
        defaultEnvironment = new CogScriptEnvironment.DefaultEnvironment();
        worldEnvironment = new CogScriptEnvironment.WorldEnvironment();
        if (libraryEnvironments != null) {
            libraryEnvironments.clear();
        }
        libraryEnvironments = new HashMap();
        File libs = new File(Minecraft.m_91087_().f_91069_, "config/cog-libs/");
        File scripts = new File(Minecraft.m_91087_().f_91069_, "config/cog/");
        File unpackedLibraries = new File(libs, ".cog");
        if (!libs.exists()) {
            libs.mkdir();
        }
        if (!scripts.exists()) {
            scripts.mkdir();
        }
        if (unpackedLibraries.exists()) {
            StoryUtils.deleteDirectory(unpackedLibraries);
        }
        unpackedLibraries.mkdir();
        CogwheelConfig.reload();
        File[] libFiles = libs.listFiles();
        ArrayList<String> libraryNames = new ArrayList<String>();
        if (libFiles != null) {
            for (File lib : libFiles) {
                String name = lib.getName();
                if (name.endsWith(".salc")) {
                    File unpacked = new File(unpackedLibraries, name);
                    if (!unpacked.mkdir()) {
                        throw new RuntimeException("Failed to create " + String.valueOf(unpacked));
                    }
                    try {
                        StoryUtils.unpackZip(lib, unpacked);
                        libraryNames.add(name);
                        continue;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to unpack " + String.valueOf(lib), e);
                    }
                }
                log.info("File {} is not StoryAnvil Locomotive Car (aka Cogwheel Engine library)", (Object)lib);
            }
        }
        for (String library : libraryNames) {
            CogScriptEnvironment.LibraryEnvironment environment = new CogScriptEnvironment.LibraryEnvironment(library);
            libraryEnvironments.put(library, environment);
        }
        log.info("Environments will be notified of initialization");
        defaultEnvironment.dispatchScript("init.sa");
        worldEnvironment.dispatchScript("init.sa");
        for (CogScriptEnvironment.LibraryEnvironment environment : libraryEnvironments.values()) {
            if (!environment.init(new File(unpackedLibraries, environment.getUniqueIdentifier()))) {
                libraryEnvironments.remove(environment.getUniqueIdentifier());
                environment.dispose();
            }
            environment.dispatchScript("init.sa");
        }
        CogwheelExecutor.createNewConsole();
        CogwheelExecutor.performVersionCheck();
    }

    public static void createNewConsole() {
        log.info("Created new console script");
        chatConsole = new StreamExecutionScript(defaultEnvironment);
    }

    public static void performVersionCheck() {
        ArtifactVersion version = ((ModContainer)ModList.get().getModContainerById("storyanvil_cogwheel").get()).getModInfo().getVersion();
        String currentVersion = version.getMajorVersion() + "." + version.getMinorVersion() + "." + version.getIncrementalVersion();
        String mcVersion = SharedConstants.m_183709_().m_132493_();
        log.info("[VerChk] Current version is: \"{}\" for minecraft \"{}\"", (Object)currentVersion, (Object)mcVersion);
        HttpClient versionChecker = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).followRedirects(HttpClient.Redirect.ALWAYS).build();
        HttpRequest.Builder request = HttpRequest.newBuilder().uri(URI.create("https://api.modrinth.com/updates/cogwheel-engine/forge_updates.json")).GET().header("User-Agent", "StoryAnvil/Cogwheel-Engine/" + currentVersion + "(storyanvil.github.io)").header("X-StoryAnvil", "Cogwheel-Engine").timeout(Duration.ofSeconds(10L));
        versionChecker.sendAsync(request.build(), HttpResponse.BodyHandlers.ofString()).thenAccept(resp -> {
            JsonObject obj = JsonParser.parseString((String)((String)resp.body())).getAsJsonObject().get("promos").getAsJsonObject();
            String recommended = obj.get(mcVersion + "-recommended").getAsString();
            String latest = obj.get(mcVersion + "-latest").getAsString();
            if (currentVersion.equals(recommended)) {
                log.info("[VerChk] Using recommended version!");
            } else if (currentVersion.equals(latest)) {
                log.info("[VerChk] Using latest version! Recommended version is {}", (Object)recommended);
            } else {
                log.warn("[VerChk] ===== [ OUTDATED VERSION ] =====");
                log.warn("[VerChk] | Recommended version: {}", (Object)recommended);
                log.warn("[VerChk] | Latest version: {}", (Object)latest);
                log.warn("[VerChk] | Current version: {}", (Object)currentVersion);
                log.warn("[VerChk] | ");
                log.warn("[VerChk] | Make sure to install recommended or latest version available");
                log.warn("[VerChk] | for new features and bug fixes.");
                log.warn("[VerChk] | https://modrinth.com/mod/cogwheel-engine/version/latest?version={}&&loader=forge", (Object)mcVersion);
                log.warn("[VerChk] ===== [ Cowheel Engine  ] =====");
            }
        });
    }

    public static StreamExecutionScript getChatConsole() {
        return chatConsole;
    }

    @SubscribeEvent
    @Api.Internal
    @ApiStatus.Internal
    public static void serverStop(ServerStoppingEvent event) {
        log.info("Disposing all CogScript environments...");
        defaultEnvironment.dispose();
        defaultEnvironment = null;
        worldEnvironment.dispose();
        worldEnvironment = null;
        for (CogScriptEnvironment.LibraryEnvironment environment : libraryEnvironments.values()) {
            environment.dispose();
        }
        libraryEnvironments = null;
    }

    @Api.Stable(since="2.0.0")
    public static CogScriptEnvironment.DefaultEnvironment getDefaultEnvironment() {
        return defaultEnvironment;
    }

    @Api.Stable(since="2.1.0")
    public static CogScriptEnvironment.WorldEnvironment getWorldEnvironment() {
        return worldEnvironment;
    }

    @Api.Stable(since="2.0.0")
    public static CogScriptEnvironment.LibraryEnvironment getLibraryEnvironment(String namespace) {
        return libraryEnvironments.get(namespace);
    }

    @Api.Experimental(since="2.0.0")
    public static Collection<CogScriptEnvironment.LibraryEnvironment> getLibraryEnvironments() {
        return libraryEnvironments.values();
    }
}

